/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.scanning.cli;

import java.util.ArrayList;
import oracle.cloud.scanning.WhitelistConnstants;
import oracle.cloud.scanning.cli.command.ApplicationScanner;
import oracle.cloud.scanning.nls.WhitelistMessageBundle;
import oracle.cloudlogic.javaservice.common.clibase.CommandLine;
import oracle.cloudlogic.javaservice.common.clibase.CommandLineArg;
import oracle.cloudlogic.javaservice.common.clibase.MainBase;
import oracle.cloudlogic.javaservice.common.clibase.nls.NLSUtil;
import oracle.cloudlogic.javaservice.common.clibase.provider.CliExecutorProvider;
import oracle.cloudlogic.javaservice.common.clibase.util.CloudUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.OrderedMap;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;

public class ScannerMain
extends MainBase
implements WhitelistConnstants {
    public static OrderedMap<String, CommandLine> allCommands = new OrderedMap();
    public static final String PARAM_CONFIG = "config";
    public static final String PARAM_FAIL_ON_WARNING = "failonwarning";
    public static final String PARAM_LOG = "log";
    public static final String COMMAND_SCAN = "scan";
    public static final String DEFAULT_PROP_SEPARATOR = ",";
    public static final String PROP_CONTEXT_PATH = "CONTEXT_PATH";
    private static final String JAR_NAME = "whitelist.jar";

    public static void addCommandLine(CommandLine command) {
        allCommands.put(command.getCommandName(), command);
    }

    @Override
    public OrderedMap<String, CommandLine> getAllCommands() {
        return allCommands;
    }

    @Override
    public String getUsage(boolean html) {
        String command1 = "java -jar whitelist.jar -log /home/log/newlog.log  /home/apps/myapp.war";
        String command2 = "java -jar whitelist.jar   myapp.jar";
        String note = NLSUtil.localizeMessage("NLS_CMD_SCAN_NOTE");
        if (html) {
            command1 = CloudUtil.textEncodetoXML(command1, true);
            command2 = CloudUtil.textEncodetoXML(command2, true);
        }
        return "java -jar whitelist.jar [-argument ...] [-help] [file1 file2 dir1 dir2 ...]  \n\n" + (html ? CloudUtil.convertToHelpText(note, 80, 5) : note) + "\n\n\nE.g\n" + "     1.)" + (html ? CloudUtil.convertToHelpText(command1, html ? 160 : 80, 10) : command1) + "\n\n     2.)" + (html ? CloudUtil.convertToHelpText(command2, html ? 160 : 80, 10) : command2);
    }

    static {
        try {
            ScannerMain main = new ScannerMain();
            MainBase.setMain(main);
            NLSUtil.addBundle(WhitelistMessageBundle.class.getName(), ScannerMain.class.getClassLoader());
            main.defaultCommand = COMMAND_SCAN;
            CommandLineArg grid = new CommandLineArg("grid", false, new CommandLineArg.BooleanOptionType(), NLSUtil.localizeMessage("NLS_PARAM_DESC_GRID_DISPLAY"));
            grid.setOptionDefaltValue("false");
            CommandLineArg summary = new CommandLineArg("includesummary", false, new CommandLineArg.BooleanOptionType(), NLSUtil.localizeMessage("NLS_PARAM_SUMMARY"));
            summary.setShortCut("is");
            summary.setOptionDefaltValue("false");
            CommandLineArg gridwidth = new CommandLineArg("gridwidth", false, new CommandLineArg.NumberOptionType(), NLSUtil.localizeMessage("NLS_PARAM_DESC_GRID_WIDTH", "grid"));
            gridwidth.setOptionDefaltValue(String.valueOf(180));
            gridwidth.setShortCut("gw");
            CommandLine command = new CommandLine();
            command.setCommandName(COMMAND_SCAN);
            command.setExtraArgs(new ArrayList<String>());
            command.setExtraArgsType(new CommandLineArg.FileOptionType(CommandLineArg.CardinalityEnum.many, " ", null, true, true));
            command.setDescription(NLSUtil.localizeMessage("NLS_CMD_SCAN"));
            command.setCliProvider(new CliExecutorProvider<ApplicationScanner>(ApplicationScanner.class));
            CommandLineArg config = new CommandLineArg(PARAM_CONFIG, false, new CommandLineArg.FileOptionType(CommandLineArg.CardinalityEnum.one, null, null, false, true), NLSUtil.localizeMessage("NLS_PARAM_CONFIG"));
            CommandLineArg failonwarning = new CommandLineArg(PARAM_FAIL_ON_WARNING, false, new CommandLineArg.BooleanOptionType(), NLSUtil.localizeMessage("NLS_PARAM_FAIL_ON_WARNING"));
            failonwarning.setHidden(true);
            config.setAdvancedOption(true);
            command.addArg(config);
            command.addArg(new CommandLineArg(PARAM_LOG, false, new CommandLineArg.FileOptionType(CommandLineArg.CardinalityEnum.one, null, null, false, true), NLSUtil.localizeMessage("NLS_CMD_LOG")));
            CommandLineArg properties = new CommandLineArg("properties", false, new CommandLineArg.PropertiesOptionType(), "The list of properties that can be passed to the glue code generator. The value of this option will be of the form key1=value1,key2=value2. Properties will be separated by , and a single property key value pair will be separated by =.");
            properties.addPropertyDescription(new CommandLineArg(PROP_CONTEXT_PATH, false, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null), "The context path of the application based on the tenant."));
            CommandLineArg propertySeparator = new CommandLineArg("keyvaluepairseparator", false, new CommandLineArg.StringOptionType(CommandLineArg.CardinalityEnum.one, null, null), "The separator for properties when more than one key=value pair is provided. The default value is ','. Use this option if one of the values contains ','. In such a case separate key=value pairs with a different separator and declare the separator used in this option.", "Property Separator", DEFAULT_PROP_SEPARATOR);
            command.addArg(failonwarning);
            command.addArg(grid);
            command.addArg(gridwidth);
            command.addArg(summary);
            command.addDebugArgs();
            command.addHelp();
            command.updateShortCut();
            ScannerMain.addCommandLine(command);
        }
        catch (Exception e) {
            Logger.getDEFAULT().printlnThrowable(e);
        }
    }
}

