/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.scanning.api.config;

import oracle.cloud.scanning.types.Severity;

public class Result {
    protected boolean allowed = true;
    protected String message;
    protected Severity severity = null;
    public static final Result PASSED = new Result();

    Result() {
    }

    Result(boolean passed, String tip, String message, Severity sev) {
        if (tip == null) {
            tip = "";
        } else {
            message = message + "\n";
        }
        this.allowed = passed;
        this.message = message + tip;
        this.severity = sev;
    }

    Result(boolean passed, String message, Severity sev) {
        this.allowed = passed;
        this.message = message;
        this.severity = sev;
    }

    public boolean isAllowed() {
        return this.allowed;
    }

    public String getMessage() {
        return this.message;
    }

    public ResultSeverity getSeverity() {
        if (!this.allowed && this.severity == null) {
            this.severity = Severity.ERROR;
        }
        if (this.allowed) {
            this.severity = null;
        }
        if (this.severity == null) {
            return null;
        }
        return ResultSeverity.valueOf(this.severity.toString());
    }

    public static enum ResultSeverity {
        HINT,
        WARNING,
        ERROR;


        public String getCaption() {
            if (HINT == this) {
                return "hint";
            }
            if (WARNING == this) {
                return "warning";
            }
            return "error";
        }
    }
}

