/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.scanning.api;

import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Pattern;
import oracle.cloud.scanning.WhitelistConnstants;
import oracle.cloud.scanning.api.Artifact;
import oracle.cloud.scanning.api.ClassArtifact;
import oracle.cloud.scanning.api.Failure;
import oracle.cloud.scanning.api.Listener;
import oracle.cloud.scanning.api.UnKnownFailure;
import oracle.cloud.scanning.api.config.Result;
import oracle.cloud.scanning.api.config.ResultTypeIdentifier;
import oracle.cloudlogic.javaservice.common.clibase.display.Cell;
import oracle.cloudlogic.javaservice.common.clibase.display.Grid;
import oracle.cloudlogic.javaservice.common.clibase.display.HeaderCell;
import oracle.cloudlogic.javaservice.common.clibase.display.Row;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;

public final class LoggingListener
implements WhitelistConnstants,
Listener {
    Logger out;
    final Stack<Artifact> stack = new Stack();
    boolean grid = false;
    boolean summary = false;
    int gridwidth = 180;
    Artifact lastArtifact;
    final Map<String, Artifact> allArtrtifacts = new HashMap<String, Artifact>();

    public LoggingListener(PrintWriter pr, boolean grid, int gridwidth) throws UnsupportedEncodingException {
        this(new Logger(pr, true), grid, gridwidth);
    }

    public LoggingListener(PrintWriter pr, boolean grid, int gridwidth, boolean summary) throws UnsupportedEncodingException {
        this(new Logger(pr, true), grid, gridwidth);
        this.summary = summary;
    }

    public LoggingListener(Logger logger, boolean grid, int gridwidth) {
        this.out = logger;
        this.grid = grid;
        this.gridwidth = gridwidth;
    }

    public LoggingListener(Logger logger, boolean grid, int gridwidth, boolean summary) {
        this(logger, grid, gridwidth);
        this.summary = summary;
    }

    @Override
    public void onInit() {
        this.allArtrtifacts.clear();
    }

    @Override
    public boolean onResourceStart(String url) {
        this.stack.clear();
        this.out.printlnDebugI18n("NLS_DEBUG_PROCESSING", url);
        this.lastArtifact = new Artifact(url);
        this.stack.push(this.lastArtifact);
        this.allArtrtifacts.put(url, this.lastArtifact);
        return true;
    }

    @Override
    public boolean onResourceReadFailure(Throwable t) {
        Artifact artifact = this.stack.peek();
        artifact.getFailures().add(new UnKnownFailure(t));
        return false;
    }

    @Override
    public void onZipStart(String path) {
        Artifact parent = this.stack.peek();
        Artifact a = new Artifact(path);
        parent.getChildren().add(a);
        this.stack.push(a);
    }

    @Override
    public void onScanning(String path) {
        Artifact parent = this.stack.peek();
        Artifact a = new Artifact(path);
        parent.getChildren().add(a);
        this.stack.push(a);
    }

    @Override
    public void onClassStart(String clazz, boolean configExempted, boolean runtimeExempted) {
        Artifact old = this.stack.pop();
        ClassArtifact clsArtifact = new ClassArtifact(old.getPath(), clazz, configExempted, runtimeExempted);
        Artifact parent = this.stack.peek();
        parent.getChildren().remove(old);
        parent.getChildren().add(clsArtifact);
        this.stack.push(clsArtifact);
    }

    @Override
    public Map<String, Pattern> onClassEnd(Map<String, Pattern> usedPackages) {
        HashMap<String, Pattern> incrementalUsedSet = new HashMap<String, Pattern>();
        if (usedPackages != null) {
            incrementalUsedSet.putAll(usedPackages);
        }
        ClassArtifact clsArtifact = (ClassArtifact)this.stack.peek();
        clsArtifact.setUsedPackagesExpression(usedPackages);
        if (clsArtifact.isConfigExempted()) {
            this.removeAllClases(incrementalUsedSet);
        }
        return incrementalUsedSet;
    }

    void removeAllClases(Map<String, Pattern> incrementalUsedSet) {
        boolean toContinueAgain = true;
        HashMap<String, Pattern> current = new HashMap<String, Pattern>(incrementalUsedSet);
        while (toContinueAgain) {
            HashMap<String, Pattern> delta = new HashMap<String, Pattern>();
            toContinueAgain = false;
            for (Artifact cls : this.allArtrtifacts.values()) {
                Map<String, Pattern> set = cls.hasMoreToExcempt(current);
                if (set == null || set.isEmpty()) continue;
                toContinueAgain = true;
                delta.putAll(set);
                current.putAll(set);
                toContinueAgain = true;
            }
            incrementalUsedSet.putAll(delta);
            current = delta;
        }
    }

    @Override
    public void onScanSuccess() {
        Artifact artrifact = null;
        artrifact = this.stack.pop();
        Artifact parent = null;
        parent = this.stack.peek();
        if (!ClassArtifact.class.isAssignableFrom(artrifact.getClass())) {
            if (parent != null) {
                parent.getChildren().remove(artrifact);
            }
        } else {
            ClassArtifact cls = (ClassArtifact)artrifact;
            if (cls.isRuntimeExempted() && parent != null) {
                parent.getChildren().remove(artrifact);
            }
        }
    }

    @Override
    public void onScanFailure(List<? extends Failure> list) {
        Artifact artifact = null;
        artifact = this.stack.pop();
        LoggingListener.filtererrors(list, artifact);
    }

    public static void filtererrors(List<? extends Failure> listoriginal, Artifact artifact) {
        if (listoriginal != null) {
            for (Failure failure : listoriginal) {
                if (failure.getSeverity() == null || failure.getSeverity() == Result.ResultSeverity.ERROR) {
                    artifact.getFailures().add(failure);
                    continue;
                }
                if (failure.getSeverity() == Result.ResultSeverity.WARNING) {
                    artifact.getWarnings().add(failure);
                    continue;
                }
                artifact.getHints().add(failure);
            }
        }
    }

    @Override
    public void onEnd() {
        this.printFailures(Result.ResultSeverity.HINT);
        this.printFailures(Result.ResultSeverity.WARNING);
        this.printFailures(Result.ResultSeverity.ERROR);
        if (this.summary) {
            this.printSummary();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printSummary() {
        Map<Result.ResultSeverity, Map<String, List<ResultTypeIdentifier>>> map = this.getSummaryReport();
        if (!map.isEmpty()) {
            Grid g = new Grid();
            g.addColumn("S.NO");
            g.addColumn("Severity");
            g.addColumn("Usage");
            g.addColumn("Usage Type");
            g.addColumn("Usage Count");
            int count = 0;
            int total = 0;
            for (Map.Entry<Result.ResultSeverity, Map<String, List<ResultTypeIdentifier>>> e : map.entrySet()) {
                Map<String, List<ResultTypeIdentifier>> innermap = e.getValue();
                for (Map.Entry<String, List<ResultTypeIdentifier>> e1 : innermap.entrySet()) {
                    ResultTypeIdentifier id = e1.getValue().get(0);
                    int col = 0;
                    Row r = g.createNewRow();
                    r.setValueAt(String.valueOf(++count), col++);
                    r.setValueAt(e.getKey().toString(), col++);
                    r.setValueAt(id.getResultId(), col++);
                    r.setValueAt(id.getResultType(), col++);
                    r.setValueAt(String.valueOf(e1.getValue().size()), col++);
                    total += e1.getValue().size();
                }
            }
            Row r = g.createNewRow();
            r.setValueAt("Total", 3);
            r.setValueAt(String.valueOf(total), 4);
            Logger logger = this.out;
            synchronized (logger) {
                this.out.setCaption("Summary");
                LoggingListener.printGridRecursive(g, "Whitelist validation summary report for all artifacts processed.", this.gridwidth, this.out);
                this.out.reSetCaption();
            }
        }
    }

    private void printFailures(Result.ResultSeverity sev) {
        long count = 0L;
        switch (sev) {
            case ERROR: {
                count = this.getTotalFailures();
                break;
            }
            case WARNING: {
                count = this.getTotalWarnings();
                break;
            }
            case HINT: {
                count = this.getTotalHints();
            }
        }
        if (count != 0L) {
            if (this.allArtrtifacts.size() > 1) {
                if (Result.ResultSeverity.ERROR == sev) {
                    this.out.printlnErrorI18n("NLS_EX_ERROR_COUNTS", count, " all artifacts that are processed.");
                } else if (Result.ResultSeverity.WARNING == sev) {
                    this.out.printlnWarningI18n("NLS_EX_WARNING_COUNTS", count, " all artifacts that are processed.");
                } else {
                    this.out.printlnWarningI18n("NLS_EX_HINTS_COUNTS", count, " all artifacts that are processed.");
                }
            }
            block20: for (Artifact artrifact : this.allArtrtifacts.values()) {
                switch (sev) {
                    case ERROR: {
                        if (artrifact.getFailureCount() != 0L) break;
                        continue block20;
                    }
                    case WARNING: {
                        if (artrifact.getWarningCount() != 0L) break;
                        continue block20;
                    }
                    case HINT: {
                        if (artrifact.getInfoCount() != 0L) break;
                        continue block20;
                    }
                }
                if (!this.grid) {
                    switch (sev) {
                        case ERROR: {
                            this.out.printlnErrorI18n("NLS_EX_ERROR_COUNTS", count, artrifact.getPath());
                            break;
                        }
                        case WARNING: {
                            this.out.printlnWarningI18n("NLS_EX_WARNING_COUNTS", count, artrifact.getPath());
                            break;
                        }
                        case HINT: {
                            this.out.printlnHintI18n("NLS_EX_HINTS_COUNTS", count, artrifact.getPath());
                        }
                    }
                    if (artrifact.getChildren().size() == 1) {
                        artrifact.getChildren().get(0).printToLogger(this.out, sev);
                    } else {
                        artrifact.printToLogger(this.out, sev);
                    }
                    switch (sev) {
                        case ERROR: {
                            this.out.printlnErrorI18n("NLS_ERR_FAILED_FOR_INPUT", artrifact.getPath(), count);
                            break;
                        }
                        case WARNING: {
                            this.out.printlnWarningI18n("NLS_ERR_WARNING_FOR_INPUT", artrifact.getPath(), count);
                            break;
                        }
                        case HINT: {
                            this.out.printlnHintI18n("NLS_HINT_WARNING_FOR_INPUT", artrifact.getPath(), count);
                        }
                    }
                    continue;
                }
                Object g = artrifact.getAsGridOrString(sev);
                if (List.class.isAssignableFrom(g.getClass())) {
                    List list = (List)g;
                    for (String l : list) {
                        this.out.println(l);
                    }
                    continue;
                }
                if (String.class.isAssignableFrom(g.getClass())) {
                    this.out.println((String)g);
                    continue;
                }
                Grid grid = null;
                if (((Grid)g).getRows().size() == 1) {
                    grid = ((Grid)g).getRows().get(0).getCells().get(1).getInnderGrid();
                }
                if (grid == null) {
                    grid = (Grid)g;
                    grid.removeColumn(0);
                }
                if (Result.ResultSeverity.ERROR == sev) {
                    LoggingListener.printGridRecursive(grid, "Whitelist validation error report - " + artrifact.getPath(), this.gridwidth, this.out);
                    continue;
                }
                if (Result.ResultSeverity.WARNING == sev) {
                    LoggingListener.printGridRecursive(grid, "Whitelist validation warning report - " + artrifact.getPath(), this.gridwidth, this.out);
                    continue;
                }
                LoggingListener.printGridRecursive(grid, "Whitelist validation hint report - " + artrifact.getPath(), this.gridwidth, this.out);
            }
        } else if (Result.ResultSeverity.ERROR == sev) {
            this.out.printlnInfoI18n("NLS_INFO_ALL_SUCCEEDED", count, this.getTotalWarnings());
        }
        this.out.flush();
        this.out.commit();
    }

    @Override
    public void onZipEnd(List<? extends Failure> list) {
        Artifact artifact = null;
        artifact = this.stack.pop();
        Artifact parent = this.stack.peek();
        Artifact a = new Artifact(artifact.getPath());
        parent.getChildren().add(a);
        LoggingListener.filtererrors(list, a);
    }

    @Override
    public void onDirectoryStart() {
        Artifact parent = this.stack.peek();
        Artifact a = new Artifact(parent.getPath());
        parent.getChildren().add(a);
        this.stack.push(a);
    }

    @Override
    public void onDirectoryEnd() {
        Artifact artrifact = null;
        artrifact = this.stack.pop();
    }

    public Artifact getLastArtifact() {
        return this.lastArtifact;
    }

    private Map<Result.ResultSeverity, Map<String, List<ResultTypeIdentifier>>> getSummaryReport() {
        HashMap<Result.ResultSeverity, Map<String, List<ResultTypeIdentifier>>> ret = new HashMap<Result.ResultSeverity, Map<String, List<ResultTypeIdentifier>>>();
        for (Artifact a : this.allArtrtifacts.values()) {
            a.updateSummaryReport(ret);
        }
        return ret;
    }

    public long getTotalFailures() {
        long totalErrors = 0L;
        for (Artifact a : this.allArtrtifacts.values()) {
            totalErrors += a.getFailureCount();
        }
        return totalErrors;
    }

    public long getTotalWarnings() {
        long totalErrors = 0L;
        for (Artifact a : this.allArtrtifacts.values()) {
            totalErrors += a.getWarningCount();
        }
        return totalErrors;
    }

    public long getTotalHints() {
        long totalErrors = 0L;
        for (Artifact a : this.allArtrtifacts.values()) {
            totalErrors += a.getInfoCount();
        }
        return totalErrors;
    }

    public static void printGridRecursive(Grid grid, String titlename, int width, Logger logger) {
        logger.println();
        if (!grid.pack(width, true, false)) {
            throw new RuntimeException("Could not form grid for the specified width. Please increase gridwidth.");
        }
        grid.printTo(logger, titlename);
        int row = 0;
        for (Row r : grid.getRows()) {
            int cell = 0;
            for (Cell c : r.getCells()) {
                HeaderCell header = grid.getColumns().getList().get(cell).getValue();
                if (c.getInnderGrid() != null && !c.isInnerGridSerialized()) {
                    logger.println();
                    LoggingListener.printGridRecursive(c.getInnderGrid(), header.getContent() + " of " + titlename + " @ row:" + (row + 1), width, logger);
                }
                ++cell;
            }
            ++row;
        }
    }

    @Override
    public void onResourceEnd() {
        Artifact artrifact = this.stack.pop();
        if (!this.stack.isEmpty()) {
            throw new RuntimeException("Un-expected Content:" + this.stack.pop().getPath());
        }
    }
}

