/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.scanning.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import oracle.cloud.common.introspection.api.FailedReference;
import oracle.cloud.scanning.api.Artifact;
import oracle.cloud.scanning.api.Failure;
import oracle.cloud.scanning.api.LoggingListener;
import oracle.cloud.scanning.api.config.ClassReferenceResult;
import oracle.cloud.scanning.api.config.Result;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;

public final class ClassArtifact
extends Artifact {
    private String className;
    private Map<String, Pattern> usedPackages = null;
    private boolean runtimeExempted;
    private boolean configExempted;

    public ClassArtifact(String path, String clazz, boolean configExempted, boolean runtimeExempted) {
        super(path);
        this.className = clazz;
        this.runtimeExempted = runtimeExempted;
        this.configExempted = configExempted;
    }

    @Override
    public long getFailureCount() {
        if (this.runtimeExempted) {
            return 0L;
        }
        return super.getFailureCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printToLogger(Logger logger, Result.ResultSeverity sev) {
        long count = 0L;
        List findings = null;
        switch (sev) {
            case ERROR: {
                count = this.getFailureCount();
                findings = this.failures;
                break;
            }
            case WARNING: {
                count = this.getWarningCount();
                findings = this.warnings;
                break;
            }
            case HINT: {
                count = this.getInfoCount();
                findings = this.info;
            }
        }
        if (count > 0L) {
            switch (sev) {
                case ERROR: {
                    logger.printlnError("Class:" + this.className + " (" + count + (count == 1L ? " Error" : " Errors") + ")");
                    break;
                }
                case WARNING: {
                    logger.printlnWarning("Class:" + this.className + " (" + count + (count == 1L ? " Warning" : " warnings") + ")");
                    break;
                }
                case HINT: {
                    logger.printlnHint("Class:" + this.className + " (" + count + (count == 1L ? " Hint" : " hints") + ")");
                }
            }
            Logger logger2 = logger;
            synchronized (logger2) {
                logger.tab();
                int c = 1;
                for (Failure f : findings) {
                    switch (sev) {
                        case ERROR: {
                            logger.printlnError(c + ":" + f.getContextualMessage());
                            break;
                        }
                        case WARNING: {
                            logger.printlnWarning(c + ":" + f.getContextualMessage());
                            break;
                        }
                        case HINT: {
                            logger.printlnHint(c + ":" + f.getContextualMessage());
                        }
                    }
                    ++c;
                }
                logger.shiftTab();
            }
        }
    }

    @Override
    protected Map<String, Pattern> hasMoreToExcempt(Map<String, Pattern> incrementalUsedSet) {
        if (this.runtimeExempted) {
            this.failures.clear();
            this.warnings.clear();
            this.info.clear();
        } else if (!this.configExempted) {
            for (Pattern p : incrementalUsedSet.values()) {
                if (!p.matcher(this.className).matches()) continue;
                incrementalUsedSet.putAll(this.usedPackages);
                this.configExempted = true;
                ArrayList<Failure> total = new ArrayList<Failure>(this.failures);
                total.addAll(this.warnings);
                total.addAll(this.info);
                this.clearAllNonResistingClassRefernces(total);
                this.warnings.clear();
                this.failures.clear();
                this.info.clear();
                LoggingListener.filtererrors(total, this);
                if (this.failures.isEmpty() && this.warnings.isEmpty() && this.info.isEmpty()) {
                    this.runtimeExempted = true;
                }
                return this.usedPackages;
            }
        }
        return null;
    }

    public void clearAllNonResistingClassRefernces(List<Failure> list) {
        ArrayList<FailedReference> newList = new ArrayList<FailedReference>();
        for (Failure f : list) {
            ClassReferenceResult classref;
            FailedReference ref;
            if (!FailedReference.class.isAssignableFrom(f.getClass()) || !ClassReferenceResult.class.isAssignableFrom((ref = (FailedReference)f).getResult().getClass()) || (classref = (ClassReferenceResult)ref.getResult()).isToBeExempted()) continue;
            classref.resetToExemptSeverity();
            newList.add(ref);
        }
        list.clear();
        list.addAll(newList);
    }

    public String getClassName() {
        return this.className;
    }

    public Collection<Pattern> getUsedPackagesExpression() {
        return this.usedPackages.values();
    }

    public void setUsedPackagesExpression(Map<String, Pattern> usedPackages) {
        this.usedPackages = usedPackages;
    }

    public boolean isRuntimeExempted() {
        return this.runtimeExempted;
    }

    public boolean isConfigExempted() {
        return this.configExempted;
    }
}

