/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.scanning;

import java.util.List;
import oracle.cloud.scanning.ScanningConstants;
import oracle.cloud.scanning.api.config.Util;
import oracle.cloud.scanning.config.imp.IPropertyFinder;
import oracle.cloud.scanning.types.IncludesAndExcludes;
import oracle.cloudlogic.javaservice.common.clibase.nls.NLSUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.CloudUtil;

public class ScanningUtil
implements ScanningConstants {
    public static String getHintForPath(IncludesAndExcludes incAndEx) {
        if (incAndEx == null) {
            return "";
        }
        List<String> includes = Util.reTranslateRxPathToPath(incAndEx.getInclude());
        List<String> excludes = Util.reTranslateRxPathToPath(incAndEx.getExclude());
        if (!includes.isEmpty()) {
            return NLSUtil.localizeMessage(Util.isWarning(incAndEx.getSeverity()) ? "NLS_HINT_INCLUSION_LIST_WARN" : (Util.isError(incAndEx.getSeverity()) ? "NLS_HINT_INCLUSION_LIST" : ""), CloudUtil.getCommaSeparatedListOfString(includes, "", "", false));
        }
        if (!excludes.isEmpty()) {
            NLSUtil.localizeMessage(Util.isWarning(incAndEx.getSeverity()) ? "NLS_HINT_EXCLUSION_LIST_WARN" : (Util.isError(incAndEx.getSeverity()) ? "NLS_HINT_EXCLUSION_LIST" : ""), CloudUtil.getCommaSeparatedListOfString(excludes, "", "", false));
        }
        return "";
    }

    public static String replace(String origString, IPropertyFinder keys) {
        if (keys == null || origString == null) {
            return origString;
        }
        StringBuffer finalString = new StringBuffer();
        int index = 0;
        int i = 0;
        String key = null;
        while ((index = origString.indexOf("${", i)) > -1) {
            int endIndex = origString.indexOf("}", index + 3);
            if (endIndex < 0) {
                throw new RuntimeException("Matching } could not be found at:" + origString);
            }
            key = origString.substring(index + 2, endIndex);
            finalString.append(origString.substring(i, index));
            String val = keys.findProperty(key);
            if (val != null) {
                finalString.append(val);
            } else {
                finalString.append("\\$\\{");
                finalString.append(key);
                finalString.append("\\}");
            }
            i = index + 3 + key.length();
        }
        finalString.append(origString.substring(i));
        return finalString.toString();
    }
}

