/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.scanning;

import oracle.cloud.scanning.api.Failure;
import oracle.cloud.scanning.api.config.Result;

public class FailedResultWrapper
implements Failure {
    private Result result;
    private int lineNo = 0;

    public FailedResultWrapper(Result res) {
        this.result = res;
    }

    public FailedResultWrapper(Result res, Object lineNumber) {
        this.result = res;
        if (lineNumber != null) {
            try {
                this.lineNo = Integer.parseInt(lineNumber.toString());
            }
            catch (Exception e) {
                this.lineNo = 0;
            }
        }
    }

    @Override
    public String getContextualMessage() {
        return this.result.getMessage() + (this.lineNo > 0 ? "Line No:" + this.lineNo + "." : "");
    }

    public Result getResult() {
        return this.result;
    }

    @Override
    public Result.ResultSeverity getSeverity() {
        return this.result.getSeverity();
    }
}

