/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.common.writer;

import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.TextFileWriter;

public class SourceFileWriter
extends TextFileWriter {
    private boolean standardStyle = true;

    public SourceFileWriter(PrintWriter pr) throws UnsupportedEncodingException {
        super(pr);
        this.setStandardStyle(false);
    }

    public void printCodeGenCaption() {
        this.printMultiLineComment(new String[]{"Decompiled "});
    }

    @Override
    public void commit() {
        StringBuffer buf = new StringBuffer(this.br.toString());
        if (this.actual != null) {
            if (this.standardStyle) {
                int indexBrace = buf.indexOf("{");
                while (indexBrace >= 0) {
                    int start;
                    for (start = indexBrace - 1; start >= 0 && (buf.charAt(start) == ' ' || buf.charAt(start) == '\n' || buf.charAt(start) == '\r'); --start) {
                        buf = buf.deleteCharAt(start);
                    }
                    indexBrace = buf.indexOf("{", start + 2);
                }
            }
            this.actual.print(buf);
            this.actual.flush();
        }
    }

    public void setStandardStyle(boolean standardStyle) {
        this.standardStyle = standardStyle;
    }

    public boolean isStandardStyle() {
        return this.standardStyle;
    }

    @Override
    public void printCommentStart() {
        this.print("// ");
    }

    public void printlnReturn(String ref) {
        this.println("return " + ref + ";");
    }

    public void printlnStateMent(String statement) {
        this.println(statement + ";");
    }

    public void printlnSetter(String setter, String value) {
        this.printlnStateMent(setter + "(" + value + ")");
    }

    public void printlnAssignment(String left, String right) {
        this.printlnStateMent(left + " = " + right);
    }

    public void printMultiLineComment(String[] comments) {
        if (comments != null) {
            this.print("/*\n");
            for (String s : comments) {
                this.print(" * " + s + "\n");
            }
            this.print(" */\n");
        }
    }
}

