/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.common.writer;

import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Set;
import oracle.cloud.common.writer.SourceFileWriter;

public class JavaSourceFileWriter
extends SourceFileWriter {
    public JavaSourceFileWriter(PrintWriter pr) throws UnsupportedEncodingException {
        super(pr);
        this.setStandardStyle(true);
    }

    public void declarePackage(String packageName) {
        if (packageName != null) {
            this.printlnStateMent("package " + packageName);
        }
    }

    public void invokeSimpleMethodStatementAndAssign(String ref, String method, String arg, String left) {
        this.invokeSimpleMethodStatementAndAssign(ref, method, arg, left, null);
    }

    public void invokeSimpleMethodStatementAndAssign(String ref, String method, String arg, String left, String castTo) {
        this.printlnAssignment(left, (castTo == null || castTo.trim().equals("") ? "" : "(" + castTo + " )") + ref + "." + method + "(" + (arg == null ? "" : arg) + ")");
    }

    public void invokeSimpleMethodStatement(String ref, String method, String arg) {
        this.printlnStateMent(ref + "." + method + "(" + (arg == null ? "" : arg) + ")");
    }

    public void insertImport(String importedClass) {
        if (importedClass != null) {
            this.printlnStateMent("import " + importedClass);
        }
    }

    public void throwRuntimeException(String comment, String baseExceptionRef) {
        if (baseExceptionRef == null && comment == null) {
            comment = "";
        }
        this.printlnStateMent("throw new RuntimeException(" + (comment != null ? "\"" + comment + "\"" : "") + (baseExceptionRef == null ? "" : "," + baseExceptionRef) + ")");
    }

    public void createNewReference(String cls, String ref, boolean declare, boolean instantiate) {
        if (declare) {
            ref = cls + " " + ref;
        }
        if (instantiate) {
            this.printlnAssignment(ref, "new " + cls + "()");
        } else {
            this.printlnAssignment(ref, "null");
        }
    }

    public void createNewReferenceWithParameters(String cls, String ref, boolean declare, boolean instantiate, String params) {
        if (declare) {
            ref = cls + " " + ref;
        }
        if (instantiate) {
            this.printlnAssignment(ref, "new " + cls + "(" + params + ")");
        } else {
            this.printlnAssignment(ref, "null");
        }
    }

    public void createNewReferenceWithStringConstructor(String cls, String ref, boolean declare, boolean instantiate, String arg) {
        if (declare) {
            ref = cls + " " + ref;
        }
        if (instantiate) {
            this.printlnAssignment(ref, "new " + cls + "(\"" + arg + "\")");
        } else {
            this.printlnAssignment(ref, "null");
        }
    }

    @Override
    public void printlnAssignment(String left, String right) {
        this.printlnStateMent(left + " = " + right);
    }

    public void startParenthesisWith(String preParanthesis) {
        this.println(preParanthesis + " {");
        this.tab();
    }

    public void startTryCatch() {
        this.startParenthesisWith("try");
    }

    public void endTryCatchInit(Class exception, String ref) {
        this.endTryCatchInit(exception.getName(), ref);
    }

    public void endTryCatchInit(String exception, String ref) {
        this.endParenthesisWith("catch (" + exception + " " + ref + ") {");
        this.tab();
    }

    public void createIfCheckNotNull(String ref) {
        this.createIf(ref + " != null");
    }

    public void createIfCheckNull(String ref) {
        this.createIf(ref + " == null");
    }

    public void declarePrivateMemberVariable(String type, String ref, boolean primitive) {
        this.printlnStateMent("private " + type + " " + ref + (primitive ? "" : " = null"));
    }

    public void declarePrivateMemberVariableNoAssign(String type, String ref) {
        this.printlnStateMent("private " + type + " " + ref);
    }

    public void declarePrivateMemberVariableAndAssign(String type, String ref, String val) {
        this.printlnStateMent("private " + type + " " + ref + " = " + val);
    }

    public void createElseCheckNull(String ref) {
        this.createElseIf(ref + " == null");
    }

    public void createElseCheckNotNull(String ref) {
        this.createElseIf(ref + " != null");
    }

    public void returnNull() {
        this.returnRef("null");
    }

    public void returnRef(String ref) {
        this.printlnStateMent("return " + ref);
    }

    public void createElseIf(String condition) {
        this.endParenthesisWith(" else if (" + condition + ") {");
        this.tab();
    }

    public void createIf(String condition) {
        this.startParenthesisWith("if (" + condition + ")");
    }

    public void endParenthesis() {
        this.endParenthesisWith("");
    }

    public void endParenthesisWith(String postParanthesis) {
        this.shiftTab();
        this.println("}" + postParanthesis);
    }

    public void declareNoArgConstructor(String className) {
        this.startParenthesisWith("public " + className + "()");
    }

    public void declareStaticBlock() {
        this.startParenthesisWith("static ");
    }

    public void invokeVoidVoidMethod(String ref, String methodName) {
        this.printlnStateMent(ref + "." + methodName + "()");
    }

    public void invokeVoidReferenceMethod(String ref, String methodName, String arg) {
        this.printlnStateMent(ref + "." + methodName + "(" + arg + ")");
    }

    public void invokeVoidStringMethod(String ref, String methodName, String arg) {
        this.printlnStateMent(ref + "." + methodName + "(\"" + arg + "\")");
    }

    public void declareClassDefinition(String className, String baseClass, Set<String> interfaces) {
        StringBuffer buffer = new StringBuffer("public class " + className + (baseClass == null ? "" : " extends " + baseClass));
        if (interfaces != null && !interfaces.isEmpty()) {
            buffer.append(" implements ");
            boolean start = true;
            for (String inter : interfaces) {
                if (!start) {
                    buffer.append(", ");
                }
                buffer.append(inter);
                start = false;
            }
        }
        this.startParenthesisWith(buffer.toString());
    }

    public void printlnToSystem(String s) {
        this.printlnStateMent("System.out.println(" + s + ")");
    }
}

