/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.common.introspection.model.sig.field;

import java.util.ArrayList;
import java.util.List;
import oracle.cloud.common.introspection.model.sig.field.FieldSignature;
import oracle.cloud.common.introspection.model.sig.field.FieldSignatureWrapper;

public class ParameterizedType
extends FieldSignature {
    private final List<FieldSignatureWrapper> parametersWrappers = new ArrayList<FieldSignatureWrapper>();

    public ParameterizedType(String typeName) {
        super(typeName);
    }

    public List<FieldSignature> getParameters() {
        ArrayList<FieldSignature> list = new ArrayList<FieldSignature>();
        for (FieldSignatureWrapper wrapper : this.parametersWrappers) {
            list.add(wrapper.getActual());
        }
        return list;
    }

    public void addParameterWrapper(FieldSignatureWrapper wrap) {
        this.parametersWrappers.add(wrap);
    }

    @Override
    public String getDeclaration() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClassDescription().getFullyQualifiedClassName());
        buffer.append("<");
        boolean first = true;
        for (FieldSignature f : this.getParameters()) {
            if (!first) {
                buffer.append(" , ");
            }
            first = false;
            buffer.append(f.getDeclaration());
        }
        buffer.append(">");
        return buffer.toString();
    }
}

