/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.common.introspection.model;

import java.util.ArrayList;
import java.util.List;
import oracle.cloud.common.introspection.ASMUtil;
import oracle.cloud.common.introspection.Accessible;
import oracle.cloud.common.introspection.Annotatable;
import oracle.cloud.common.introspection.access.Access;
import oracle.cloud.common.introspection.access.InnerClassAccess;
import oracle.cloud.common.introspection.access.TypeAccess;
import oracle.cloud.common.introspection.model.Annotation;
import oracle.cloud.common.introspection.model.Argument;
import oracle.cloud.common.introspection.model.ClassDesciption;
import oracle.cloud.common.introspection.model.Field;
import oracle.cloud.common.introspection.model.Method;
import oracle.cloud.common.introspection.model.sig.ClassSignature;
import oracle.cloud.common.introspection.usage.impl.AbstractUsageImpl;
import oracle.cloud.common.writer.JavaSourceFileWriter;
import oracle.cloudlogic.javaservice.common.clibase.util.OrderedMap;

public class Type
implements Annotatable,
Accessible {
    private String nameAsInClassFile;
    private TypeAccess access;
    private int version;
    private final List<Annotation> annotations = new ArrayList<Annotation>();
    private final List<Field> fields = new ArrayList<Field>();
    private final List<Method> methods = new ArrayList<Method>();
    private String sourceInfo;
    private String debugInfo;
    private String baseType;
    private String[] interfaces;
    private ClassSignature signature;
    private ClassDesciption classDescription;

    public void setNameAsInClassFile(String name) {
        this.nameAsInClassFile = name;
        this.classDescription = new ClassDesciption(name);
    }

    public void setDebugInfo(String debugInfo) {
        this.debugInfo = debugInfo;
    }

    public String getDebugInfo() {
        return this.debugInfo;
    }

    public void setSourceInfo(String sourceInfo) {
        this.sourceInfo = sourceInfo;
    }

    public String getSourceInfo() {
        return this.sourceInfo;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getVersion() {
        return this.version;
    }

    public void setAccess(TypeAccess access) {
        this.access = access;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public String getBaseType() {
        return this.baseType;
    }

    public void setInterfaces(String[] interfaces) {
        this.interfaces = interfaces;
    }

    public String[] getInterfaces() {
        return this.interfaces;
    }

    public ClassSignature getSignature() {
        return this.signature;
    }

    public void setSignature(ClassSignature signature) {
        this.signature = signature;
    }

    public ClassDesciption getClassDescription() {
        return this.classDescription;
    }

    @Override
    public Annotatable.TARGET getTarget() {
        return Annotatable.TARGET.TYPE;
    }

    @Override
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    @Override
    public Access getAccess() {
        return this.access;
    }

    public List<Method> getMethods() {
        return this.methods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deCompile(JavaSourceFileWriter pr) {
        try {
            if (this.nameAsInClassFile == null) {
                throw new RuntimeException("class name is not found");
            }
            if (this.access == null) {
                throw new Exception("access is not set");
            }
            for (Annotation a : this.annotations) {
                pr.println(a.getDeclaration());
            }
            pr.print(this.access.getSignature() + " ");
            pr.print(this.classDescription.getClassName());
            if (this.signature != null) {
                pr.print(this.signature.getDeclaration());
            }
            pr.println("{");
            pr.tab();
            pr.printlnComment("fields");
            for (Field f : this.fields) {
                for (Annotation a : f.getAnnotations()) {
                    pr.println(a.getDeclaration());
                }
                String val = "";
                if (f.getValue() != null) {
                    val = " = " + f.getValueAsString();
                }
                pr.printlnStateMent(f.getAccess().getSignature() + " " + f.getSignature().getDeclaration() + " " + f.getName() + val);
            }
            pr.printlnComment("methods");
            for (Method m : this.methods) {
                for (Annotation a : m.getAnnotations()) {
                    pr.println(a.getDeclaration());
                }
                pr.print(m.getAccess().getSignature());
                pr.print(ASMUtil.asDeclaration(m.getParameters()));
                pr.print(" ");
                for (Annotation a : m.getReturnType().getAnnotations()) {
                    pr.println(a.getDeclaration());
                }
                pr.print(m.getReturnType().getSignature().getDeclaration() + " " + m.getName() + "(");
                int count = 0;
                for (Argument a : m.getArguments()) {
                    if (count != 0) {
                        pr.print(", ");
                    }
                    for (Annotation an : a.getAnnotations()) {
                        pr.println(an.getDeclaration());
                    }
                    pr.print(a.getSignature().getDeclaration() + " arg" + count);
                    ++count;
                }
                pr.print(")");
                if (m.getAccess().isAbstract()) {
                    if (m.getAnnotatonMethodDefaultValue() != null) {
                        pr.print(" default " + m.getAnnotatonMethodDefaultValue().getValueDeclaration());
                    }
                    pr.printlnStateMent("");
                    continue;
                }
                pr.println("{");
                pr.tab();
                pr.printlnComment("Usages");
                OrderedMap<String, String> orderedMap = pr.initMapText();
                synchronized (orderedMap) {
                    for (AbstractUsageImpl u : m.getUsages()) {
                        pr.addMapText("ln:" + String.valueOf(u.getLineNumber()), u.getAsString());
                    }
                    pr.endMapText();
                }
                pr.shiftTab();
                pr.println("}");
            }
            pr.shiftTab();
            pr.println("}");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class OUTER_CLASS {
        private String owner;
        private String name;
        private String methodDesc;

        public void setOwner(String owner) {
            this.owner = owner;
        }

        public String getOwner() {
            return this.owner;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class INNER_CLASS
    implements Accessible {
        private InnerClassAccess access;
        private String name;
        private String outerName;
        private String innerName;

        @Override
        public Access getAccess() {
            return this.access;
        }

        public void setAccess(InnerClassAccess access) {
            this.access = access;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setOuterName(String outerName) {
            this.outerName = outerName;
        }

        public void setInnerName(String innerName) {
            this.innerName = innerName;
        }

        public String getInnerName() {
            return this.innerName;
        }
    }
}

