/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.common.introspection.model;

import java.util.ArrayList;
import java.util.List;
import oracle.cloud.common.introspection.Accessible;
import oracle.cloud.common.introspection.Annotatable;
import oracle.cloud.common.introspection.access.MethodAccess;
import oracle.cloud.common.introspection.asm.visitor.AnnotationVisitorImpl;
import oracle.cloud.common.introspection.model.Annotation;
import oracle.cloud.common.introspection.model.Argument;
import oracle.cloud.common.introspection.model.sig.Bound;
import oracle.cloud.common.introspection.model.sig.ClassSignature;
import oracle.cloud.common.introspection.model.sig.field.FieldSignatureWrapper;
import oracle.cloud.common.introspection.usage.impl.AbstractUsageImpl;
import oracle.cloud.common.introspection.value.SimpleValued;
import oracle.cloudlogic.javaservice.common.clibase.util.OrderedMap;

public class Method
implements Annotatable,
Accessible {
    private String name;
    private final List<FieldSignatureWrapper> exceptionClassNames = new ArrayList<FieldSignatureWrapper>();
    private final List<Annotation> annotations = new ArrayList<Annotation>();
    private MethodAccess access;
    private Argument returnType;
    private final List<Argument> arguments = new ArrayList<Argument>();
    private final OrderedMap<String, Bound> parameters = new OrderedMap();
    private final List<AbstractUsageImpl> usages = new ArrayList<AbstractUsageImpl>();
    private AnnotationVisitorImpl annotatonMethodDefaultValueProvider;

    public List<String> getArgumentTypes() {
        ArrayList<String> list = new ArrayList<String>();
        for (Argument p : this.arguments) {
            list.add(p.getClassName());
        }
        return list;
    }

    public boolean isConstructor() {
        return "<init>".equals(this.name);
    }

    public void setClassBound(String formalParam, ClassSignature sig) {
        Bound b = new Bound();
        b.setClassBound(sig);
        b.setFormalParameter(formalParam);
        this.parameters.put(formalParam, b);
    }

    public void addInterfaceBound(String formalParam, ClassSignature sig) {
        Bound b = this.parameters.get(formalParam);
        if (b == null) {
            b = new Bound();
        }
        b.setFormalParameter(formalParam);
        b.getInterfacesBound().add(sig);
        this.parameters.put(formalParam, b);
    }

    @Override
    public Annotatable.TARGET getTarget() {
        return Annotatable.TARGET.METHOD;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public MethodAccess getAccess() {
        return this.access;
    }

    public Argument getReturnType() {
        return this.returnType;
    }

    public List<Argument> getArguments() {
        return this.arguments;
    }

    public void setAccess(MethodAccess access) {
        this.access = access;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<AbstractUsageImpl> getUsages() {
        return this.usages;
    }

    public void setReturnType(Argument returnType) {
        this.returnType = returnType;
    }

    public OrderedMap<String, Bound> getParameters() {
        return this.parameters;
    }

    public List<FieldSignatureWrapper> getExceptionClassNames() {
        return this.exceptionClassNames;
    }

    public SimpleValued getAnnotatonMethodDefaultValue() {
        return this.annotatonMethodDefaultValueProvider.getAnnotation().getVales().get(0);
    }

    public void setAnnotatonMethodDefaultValueProvider(AnnotationVisitorImpl annotatonMethodDefaultValueProvider) {
        this.annotatonMethodDefaultValueProvider = annotatonMethodDefaultValueProvider;
    }
}

