/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.common.introspection.model;

import java.util.ArrayList;
import java.util.List;
import oracle.cloud.common.introspection.value.AnnotationValued;
import oracle.cloud.common.introspection.value.ArrayValued;
import oracle.cloud.common.introspection.value.EnumValued;
import oracle.cloud.common.introspection.value.PrimitiveValued;
import oracle.cloud.common.introspection.value.SimpleValued;
import org.objectweb.asm.Type;

public class Annotation {
    private String typeName;
    private final List<SimpleValued> values = new ArrayList<SimpleValued>();

    public Annotation(String name) {
        this.typeName = name;
    }

    public String getDeclaration() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("@" + this.getTypeName().replace('$', '.'));
        if (!this.values.isEmpty()) {
            buffer.append("(\n");
            boolean first = true;
            for (SimpleValued val : this.values) {
                if (!first) {
                    buffer.append(",");
                }
                first = false;
                buffer.append(val.getName() + " = ");
                String value = val.getValueDeclaration();
                buffer.append(value);
            }
            buffer.append("\n)");
        }
        return buffer.toString();
    }

    public String getClassName() {
        return this.typeName.replace('$', '.');
    }

    private String getTypeName() {
        return this.typeName;
    }

    public List<SimpleValued> getVales() {
        return this.values;
    }

    public void setNestedAnnotation(String name, Annotation a) {
        this.values.add(new AnnotationValued(name, a));
    }

    public void setDiectValue(String name, Object obj) {
        this.values.add(new PrimitiveValued(name, obj));
    }

    public void setEnumValue(String name, String desc, String val) {
        this.values.add(new EnumValued(name, Type.getType(desc).getClassName(), val));
    }

    public void setArrayValues(String name, List<SimpleValued> values) {
        values.add(new ArrayValued(name, values));
    }
}

