/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.common.introspection.asm.visitor;

import java.util.HashMap;
import java.util.Map;
import oracle.cloud.common.introspection.ASMUtil;
import oracle.cloud.common.introspection.asm.visitor.AnnotationVisitorImpl;
import oracle.cloud.common.introspection.model.Annotation;
import oracle.cloud.common.introspection.model.ClassDesciption;
import oracle.cloud.common.introspection.model.Method;
import oracle.cloud.common.introspection.usage.impl.FieldUsageImpl;
import oracle.cloud.common.introspection.usage.impl.MethodUsageImpl;
import oracle.cloud.common.introspection.usage.impl.TypeUsageImpl;
import oracle.cloud.common.introspection.usage.impl.VariableUsageImpl;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class MethodVisitorImpl
implements MethodVisitor {
    Method method = null;
    private int lastLineNumber = -1;
    private final Map<Label, Integer> mapLineNumber = new HashMap<Label, Integer>();
    public boolean DEBUG = false;

    public MethodVisitorImpl(Method method) {
        this.method = method;
    }

    @Override
    public AnnotationVisitor visitAnnotationDefault() {
        AnnotationVisitorImpl impl = new AnnotationVisitorImpl(new Annotation(null));
        this.method.setAnnotatonMethodDefaultValueProvider(impl);
        return impl;
    }

    private void putLineNumberForLabel(Label label) {
        this.mapLineNumber.put(label, this.lastLineNumber);
    }

    private int getLineNumberForLabel(Label label) {
        Integer l = this.mapLineNumber.get(label);
        if (l == null) {
            return this.lastLineNumber;
        }
        return l;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        Annotation annotation = new Annotation(Type.getType(desc).getClassName());
        this.method.getAnnotations().add(annotation);
        return new AnnotationVisitorImpl(annotation);
    }

    @Override
    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        if (this.DEBUG) {
            System.out.println("Parameter:" + parameter + " desc:" + desc + " visible:" + visible);
        }
        if (this.method.getArguments().size() <= parameter) {
            parameter = this.method.getArguments().size() - 1;
        }
        if (parameter < 0) {
            return null;
        }
        Annotation annotation = new Annotation(Type.getType(desc).getClassName());
        this.method.getArguments().get(parameter).getAnnotations().add(annotation);
        return new AnnotationVisitorImpl(annotation);
    }

    @Override
    public void visitAttribute(Attribute attribute) {
    }

    @Override
    public void visitCode() {
    }

    @Override
    public void visitFrame(int i, int i1, Object[] objects, int i2, Object[] objects1) {
    }

    @Override
    public void visitInsn(int i) {
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
    }

    @Override
    public void visitTypeInsn(int opcode, String type) {
        TypeUsageImpl usage = new TypeUsageImpl(this.lastLineNumber);
        usage.setOpcode(opcode);
        usage.setType(new ClassDesciption(Type.getObjectType(type).getClassName()));
        this.method.getUsages().add(usage);
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        FieldUsageImpl usage = new FieldUsageImpl(this.lastLineNumber);
        usage.setName(name);
        usage.setOwner(new ClassDesciption(owner));
        usage.setSignature(ASMUtil.fromDescToFieldSignature(desc));
        this.method.getUsages().add(usage);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        Type[] args;
        MethodUsageImpl u = new MethodUsageImpl(this.lastLineNumber);
        u.setOwner(new ClassDesciption(Type.getObjectType(owner).getClassName()));
        u.setName(name);
        u.setOpCode(opcode);
        this.method.getUsages().add(u);
        for (Type arg : args = Type.getArgumentTypes(desc)) {
            u.getArguments().add(new ClassDesciption(arg.getClassName()));
        }
    }

    @Override
    public void visitJumpInsn(int opcode, Label label) {
    }

    @Override
    public void visitLabel(Label label) {
        this.putLineNumberForLabel(label);
    }

    @Override
    public void visitLdcInsn(Object object) {
    }

    @Override
    public void visitIincInsn(int var, int increment) {
    }

    @Override
    public void visitTableSwitchInsn(int i, int i1, Label label, Label[] labels) {
    }

    @Override
    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
    }

    @Override
    public void visitMultiANewArrayInsn(String string, int i) {
    }

    @Override
    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
    }

    @Override
    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        VariableUsageImpl usage = new VariableUsageImpl(this.getLineNumberForLabel(start));
        usage.setName(name);
        if (signature != null) {
            usage.setSignature(ASMUtil.fromSignatureToFieldSignature(signature));
        } else {
            usage.setSignature(ASMUtil.fromDescToFieldSignature(desc));
        }
        this.method.getUsages().add(usage);
    }

    @Override
    public void visitLineNumber(int i, Label label) {
        if (this.lastLineNumber < 0) {
            this.lastLineNumber = i;
        }
        this.putLineNumberForLabel(label);
        this.lastLineNumber = i;
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
    }

    @Override
    public void visitEnd() {
    }
}

