/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.common.introspection.asm.visitor;

import oracle.cloud.common.introspection.model.sig.field.ArrayType;
import oracle.cloud.common.introspection.model.sig.field.DirectType;
import oracle.cloud.common.introspection.model.sig.field.ExtendsWildCardType;
import oracle.cloud.common.introspection.model.sig.field.FieldSignatureWrapper;
import oracle.cloud.common.introspection.model.sig.field.ParameterizedType;
import oracle.cloud.common.introspection.model.sig.field.QuestionMarkType;
import oracle.cloud.common.introspection.model.sig.field.SuperWildCardType;
import oracle.cloud.common.introspection.model.sig.field.TypeVariable;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureVisitor;

public class FieldSignatureVisitor
implements SignatureVisitor {
    private FieldSignatureWrapper wrapper;
    public static boolean DEBUG = false;

    public FieldSignatureVisitor(FieldSignatureWrapper wrapper) {
        this.wrapper = wrapper;
    }

    @Override
    public void visitFormalTypeParameter(String formalParam) {
        throw new RuntimeException("visitFormalTypeParameter:" + this);
    }

    @Override
    public SignatureVisitor visitClassBound() {
        throw new RuntimeException("class bound:" + this);
    }

    @Override
    public SignatureVisitor visitInterfaceBound() {
        throw new RuntimeException("inteface bound" + this);
    }

    @Override
    public SignatureVisitor visitSuperclass() {
        if (DEBUG) {
            System.out.println("Visiting super class:" + this);
        }
        return this;
    }

    @Override
    public SignatureVisitor visitInterface() {
        throw new RuntimeException("visiting interfaces:" + this);
    }

    @Override
    public SignatureVisitor visitParameterType() {
        throw new RuntimeException("Un-expected invocation");
    }

    @Override
    public SignatureVisitor visitReturnType() {
        throw new RuntimeException("Un-expected invocation");
    }

    @Override
    public SignatureVisitor visitExceptionType() {
        throw new RuntimeException("Un-expected invocation");
    }

    @Override
    public void visitBaseType(char c) {
        if (DEBUG) {
            System.out.println("visitBaseType:" + c);
        }
        this.wrapper.setActual(new DirectType(Type.getType(String.valueOf(c)).getClassName()));
    }

    @Override
    public void visitTypeVariable(String name) {
        if (DEBUG) {
            System.out.println("type variable:" + name);
        }
        this.wrapper.setActual(new TypeVariable(name));
    }

    @Override
    public SignatureVisitor visitArrayType() {
        if (DEBUG) {
            System.out.println("visit Array Type");
        }
        FieldSignatureWrapper new_wrapper = new FieldSignatureWrapper();
        this.wrapper.setActual(new ArrayType(new_wrapper));
        return new FieldSignatureVisitor(new_wrapper);
    }

    @Override
    public void visitClassType(String name) {
        if (DEBUG) {
            System.out.println("visitng class " + name + " :" + this);
        }
        this.wrapper.setClassType(name);
    }

    @Override
    public void visitInnerClassType(String name) {
        if (DEBUG) {
            System.out.println("visitng inner class " + name + " :" + this);
        }
        this.wrapper.setClassType(this.wrapper.getClassType() + "." + name);
        this.wrapper.setActual(null);
    }

    @Override
    public void visitTypeArgument() {
        if (DEBUG) {
            System.out.println("Visiting type argument:");
        }
        if (!this.wrapper.isTypeSet()) {
            this.wrapper.setActual(new ParameterizedType(this.wrapper.getClassType()));
            if (DEBUG) {
                System.out.println("Creating parameterized type");
            }
        }
        ParameterizedType paramType = (ParameterizedType)this.wrapper.getActual();
        FieldSignatureWrapper wraper = new FieldSignatureWrapper();
        wraper.setActual(new QuestionMarkType());
        paramType.addParameterWrapper(wraper);
    }

    @Override
    public SignatureVisitor visitTypeArgument(char tag) {
        if (DEBUG) {
            System.out.println("Visiting type argument:" + tag);
        }
        if (!this.wrapper.isTypeSet()) {
            this.wrapper.setActual(new ParameterizedType(this.wrapper.getClassType()));
            if (DEBUG) {
                System.out.println("Creating parameterized type");
            }
        }
        ParameterizedType paramType = (ParameterizedType)this.wrapper.getActual();
        if (tag == '=') {
            FieldSignatureWrapper newwrapper = new FieldSignatureWrapper();
            paramType.addParameterWrapper(newwrapper);
            return new FieldSignatureVisitor(newwrapper);
        }
        if (tag == '-') {
            FieldSignatureWrapper superWrappter = new FieldSignatureWrapper();
            paramType.addParameterWrapper(superWrappter);
            FieldSignatureWrapper newwrapper = new FieldSignatureWrapper();
            superWrappter.setActual(new SuperWildCardType(newwrapper));
            return new FieldSignatureVisitor(newwrapper);
        }
        if (tag == '+') {
            FieldSignatureWrapper extendsWrapper = new FieldSignatureWrapper();
            paramType.addParameterWrapper(extendsWrapper);
            FieldSignatureWrapper newwrapper = new FieldSignatureWrapper();
            extendsWrapper.setActual(new ExtendsWildCardType(newwrapper));
            return new FieldSignatureVisitor(newwrapper);
        }
        throw new RuntimeException("Visiting type argument:" + tag);
    }

    @Override
    public void visitEnd() {
        if (DEBUG) {
            System.out.println("Visit ends:" + this);
        }
        if (!this.wrapper.isTypeSet()) {
            this.wrapper.setActual(new DirectType(this.wrapper.getClassType()));
        }
    }
}

