/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.common.introspection.asm.visitor;

import oracle.cloud.common.introspection.ASMUtil;
import oracle.cloud.common.introspection.access.FieldAccess;
import oracle.cloud.common.introspection.access.MethodAccess;
import oracle.cloud.common.introspection.access.TypeAccess;
import oracle.cloud.common.introspection.asm.visitor.AnnotationVisitorImpl;
import oracle.cloud.common.introspection.asm.visitor.ClassSignatureVisitorImpl;
import oracle.cloud.common.introspection.asm.visitor.FieldVisitorImpl;
import oracle.cloud.common.introspection.asm.visitor.MethodSignatureVisitor;
import oracle.cloud.common.introspection.asm.visitor.MethodVisitorImpl;
import oracle.cloud.common.introspection.model.Annotation;
import oracle.cloud.common.introspection.model.Field;
import oracle.cloud.common.introspection.model.Method;
import oracle.cloud.common.introspection.model.Type;
import oracle.cloud.common.introspection.model.sig.ClassSignature;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.signature.SignatureReader;

public class ClassVisitorImpl
implements ClassVisitor {
    private Type type;

    public ClassVisitorImpl(Type type) {
        this.type = type;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.type.setVersion(version);
        this.type.setAccess(new TypeAccess(access));
        this.type.setNameAsInClassFile(name);
        this.type.setBaseType(superName);
        this.type.setInterfaces(interfaces);
        if (signature != null) {
            ClassSignature sig = new ClassSignature();
            this.type.setSignature(sig);
            SignatureReader reader = new SignatureReader(signature);
            reader.accept(new ClassSignatureVisitorImpl(sig));
        }
    }

    @Override
    public void visitSource(String string, String string1) {
    }

    @Override
    public void visitOuterClass(String string, String string1, String string2) {
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        Annotation annotation = new Annotation(org.objectweb.asm.Type.getType(desc).getClassName());
        this.type.getAnnotations().add(annotation);
        return new AnnotationVisitorImpl(annotation);
    }

    @Override
    public void visitAttribute(Attribute attribute) {
    }

    @Override
    public void visitInnerClass(String string, String string1, String string2, int i) {
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        Field field = new Field(this.type);
        field.setAccess(new FieldAccess(access));
        field.setName(name);
        field.setValue(value);
        if (signature != null) {
            field.setSignature(ASMUtil.fromSignatureToFieldSignature(signature));
        } else {
            field.setSignature(ASMUtil.fromDescToFieldSignature(desc));
        }
        this.type.getFields().add(field);
        return new FieldVisitorImpl(field);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        Method method = new Method();
        method.setAccess(new MethodAccess(access));
        method.setName(name);
        MethodVisitorImpl v = new MethodVisitorImpl(method);
        if (signature != null) {
            MethodSignatureVisitor visitor = new MethodSignatureVisitor(method);
            SignatureReader reader = new SignatureReader(signature);
            reader.accept(visitor);
        } else {
            ASMUtil.updateMethod(desc, method, exceptions);
        }
        this.type.getMethods().add(method);
        return v;
    }

    @Override
    public void visitEnd() {
    }
}

