/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.common.introspection.asm.visitor;

import oracle.cloud.common.introspection.model.sig.ClassSignature;
import org.objectweb.asm.signature.SignatureVisitor;

public class ClassSignatureVisitorImpl
implements SignatureVisitor {
    private ClassSignature signature;
    private String formalParam;

    public ClassSignatureVisitorImpl(ClassSignature sig) {
        this.signature = sig;
    }

    public ClassSignature getSignature() {
        return this.signature;
    }

    @Override
    public void visitFormalTypeParameter(String formalParam) {
        this.formalParam = formalParam;
    }

    @Override
    public SignatureVisitor visitClassBound() {
        ClassSignature s = new ClassSignature();
        ClassSignatureVisitorImpl v = new ClassSignatureVisitorImpl(s);
        this.signature.setClassBound(this.formalParam, s);
        return v;
    }

    @Override
    public SignatureVisitor visitInterfaceBound() {
        ClassSignature s = new ClassSignature();
        ClassSignatureVisitorImpl v = new ClassSignatureVisitorImpl(s);
        this.signature.addInterfaceBound(this.formalParam, s);
        return v;
    }

    @Override
    public SignatureVisitor visitSuperclass() {
        ClassSignature s = new ClassSignature();
        ClassSignatureVisitorImpl v = new ClassSignatureVisitorImpl(s);
        this.signature.setBase(s);
        return v;
    }

    @Override
    public SignatureVisitor visitInterface() {
        ClassSignature s = new ClassSignature();
        ClassSignatureVisitorImpl v = new ClassSignatureVisitorImpl(s);
        this.signature.getInterfaces().add(s);
        return v;
    }

    @Override
    public SignatureVisitor visitParameterType() {
        throw new RuntimeException("Un-expected invocation");
    }

    @Override
    public SignatureVisitor visitReturnType() {
        throw new RuntimeException("Un-expected invocation");
    }

    @Override
    public SignatureVisitor visitExceptionType() {
        throw new RuntimeException("Un-expected invocation");
    }

    @Override
    public void visitBaseType(char c) {
    }

    @Override
    public void visitTypeVariable(String name) {
        this.signature.setNameAsInClassFile(name);
    }

    @Override
    public SignatureVisitor visitArrayType() {
        this.signature.incrementDimension();
        return this;
    }

    @Override
    public void visitClassType(String name) {
        this.signature.setNameAsInClassFile(name);
    }

    @Override
    public void visitInnerClassType(String string) {
        this.signature.setNameAsInClassFile(this.signature.getClassDescription().getFullyQualifiedClassName() + "." + string);
        this.signature.getTypeVariables().clear();
    }

    @Override
    public void visitTypeArgument() {
        ClassSignature sig = new ClassSignature();
        sig.setNameAsInClassFile("?");
        this.signature.getTypeVariables().add(sig);
    }

    @Override
    public SignatureVisitor visitTypeArgument(char tag) {
        ClassSignature sig = new ClassSignature();
        if (tag != '=') {
            throw new RuntimeException("Visiting type argument:" + tag);
        }
        this.signature.getTypeVariables().add(sig);
        return new ClassSignatureVisitorImpl(sig);
    }

    @Override
    public void visitEnd() {
    }
}

