/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.common.introspection.api.ref;

import java.util.LinkedList;
import java.util.List;

public abstract class Reference {
    private String message;
    protected Reference parent;

    public Reference(String mes, Reference p) {
        this.message = mes;
        this.parent = p;
    }

    protected String getMessage() {
        return this.message;
    }

    public List<String> getMessages() {
        LinkedList<String> list = new LinkedList<String>();
        Reference r = this;
        while (r != null) {
            list.addFirst(r.getMessage());
            r = r.parent;
        }
        return list;
    }

    public String getContextualMessage() {
        StringBuffer buf = new StringBuffer();
        int count = 0;
        for (String s : this.getMessages()) {
            if (count != 0) {
                // empty if block
            }
            for (int i = 0; i < count; ++i) {
                buf.append(" ");
            }
            if (count != 0) {
                buf.append("->");
            }
            buf.append(s);
            ++count;
        }
        return buf.toString();
    }

    public Reference getParent() {
        return this.parent;
    }
}

