/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.common.introspection.access;

public abstract class Access {
    protected int access;

    public Access(int access) {
        this.access = access;
    }

    public void setAccess(int acces) {
        this.access = acces;
    }

    public int getAccess() {
        return this.access;
    }

    public boolean isDeprecated() {
        return (this.access & 0x20000) != 0;
    }

    public boolean isPrivate() {
        return (this.access & 2) != 0;
    }

    public boolean isProtected() {
        return (this.access & 4) != 0;
    }

    public boolean isPublic() {
        return (this.access & 1) != 0;
    }

    public boolean isFinal() {
        return (this.access & 0x10) != 0;
    }

    public boolean isStatic() {
        return (this.access & 8) != 0;
    }

    public boolean isPackagePrivate() {
        return !this.isPrivate() && !this.isProtected() && !this.isPublic();
    }

    public String getAccessSpecifer() {
        if (this.isPublic()) {
            return "public";
        }
        if (this.isPrivate()) {
            return "private";
        }
        if (this.isProtected()) {
            return "protected";
        }
        return "";
    }

    public abstract String getSignature();
}

