/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTMatcher;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.InferredType;
import org.eclipse.wst.jsdt.core.dom.JSdoc;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SimplePropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Type;

public class FunctionDeclaration
extends BodyDeclaration {
    public static final ChildPropertyDescriptor JAVADOC_PROPERTY = FunctionDeclaration.internalJavadocPropertyFactory(FunctionDeclaration.class);
    public static final SimplePropertyDescriptor MODIFIERS_PROPERTY = FunctionDeclaration.internalModifiersPropertyFactory(FunctionDeclaration.class);
    public static final ChildListPropertyDescriptor MODIFIERS2_PROPERTY = FunctionDeclaration.internalModifiers2PropertyFactory(FunctionDeclaration.class);
    public static final SimplePropertyDescriptor CONSTRUCTOR_PROPERTY = new SimplePropertyDescriptor(FunctionDeclaration.class, "constructor", Boolean.TYPE, true);
    public static final ChildPropertyDescriptor NAME_PROPERTY = new ChildPropertyDescriptor(FunctionDeclaration.class, "name", SimpleName.class, false, false);
    public static final ChildPropertyDescriptor RETURN_TYPE_PROPERTY = new ChildPropertyDescriptor(FunctionDeclaration.class, "returnType", Type.class, false, false);
    public static final ChildPropertyDescriptor RETURN_TYPE2_PROPERTY = new ChildPropertyDescriptor(FunctionDeclaration.class, "returnType2", Type.class, false, false);
    public static final SimplePropertyDescriptor EXTRA_DIMENSIONS_PROPERTY = new SimplePropertyDescriptor(FunctionDeclaration.class, "extraDimensions", Integer.TYPE, true);
    public static final ChildListPropertyDescriptor PARAMETERS_PROPERTY = new ChildListPropertyDescriptor(FunctionDeclaration.class, "parameters", SingleVariableDeclaration.class, true);
    public static final ChildListPropertyDescriptor THROWN_EXCEPTIONS_PROPERTY = new ChildListPropertyDescriptor(FunctionDeclaration.class, "thrownExceptions", Name.class, false);
    public static final ChildPropertyDescriptor BODY_PROPERTY = new ChildPropertyDescriptor(FunctionDeclaration.class, "body", Block.class, false, true);
    private static final List PROPERTY_DESCRIPTORS_2_0;
    private static final List PROPERTY_DESCRIPTORS_3_0;
    private boolean isConstructor = false;
    private SimpleName methodName = null;
    private ASTNode.NodeList parameters = new ASTNode.NodeList(PARAMETERS_PROPERTY);
    private Type returnType = null;
    private boolean returnType2Initialized = false;
    private int extraArrayDimensions = 0;
    private ASTNode.NodeList thrownExceptions = new ASTNode.NodeList(THROWN_EXCEPTIONS_PROPERTY);
    private Block optionalBody = null;

    static {
        ArrayList propertyList = new ArrayList(10);
        FunctionDeclaration.createPropertyList(FunctionDeclaration.class, propertyList);
        FunctionDeclaration.addProperty(JAVADOC_PROPERTY, propertyList);
        FunctionDeclaration.addProperty(MODIFIERS_PROPERTY, propertyList);
        FunctionDeclaration.addProperty(CONSTRUCTOR_PROPERTY, propertyList);
        FunctionDeclaration.addProperty(RETURN_TYPE_PROPERTY, propertyList);
        FunctionDeclaration.addProperty(NAME_PROPERTY, propertyList);
        FunctionDeclaration.addProperty(PARAMETERS_PROPERTY, propertyList);
        FunctionDeclaration.addProperty(EXTRA_DIMENSIONS_PROPERTY, propertyList);
        FunctionDeclaration.addProperty(THROWN_EXCEPTIONS_PROPERTY, propertyList);
        FunctionDeclaration.addProperty(BODY_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS_2_0 = FunctionDeclaration.reapPropertyList(propertyList);
        propertyList = new ArrayList(11);
        FunctionDeclaration.createPropertyList(FunctionDeclaration.class, propertyList);
        FunctionDeclaration.addProperty(JAVADOC_PROPERTY, propertyList);
        FunctionDeclaration.addProperty(MODIFIERS2_PROPERTY, propertyList);
        FunctionDeclaration.addProperty(CONSTRUCTOR_PROPERTY, propertyList);
        FunctionDeclaration.addProperty(RETURN_TYPE2_PROPERTY, propertyList);
        FunctionDeclaration.addProperty(NAME_PROPERTY, propertyList);
        FunctionDeclaration.addProperty(PARAMETERS_PROPERTY, propertyList);
        FunctionDeclaration.addProperty(EXTRA_DIMENSIONS_PROPERTY, propertyList);
        FunctionDeclaration.addProperty(THROWN_EXCEPTIONS_PROPERTY, propertyList);
        FunctionDeclaration.addProperty(BODY_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS_3_0 = FunctionDeclaration.reapPropertyList(propertyList);
    }

    public static List propertyDescriptors(int apiLevel) {
        if (apiLevel == 2) {
            return PROPERTY_DESCRIPTORS_2_0;
        }
        return PROPERTY_DESCRIPTORS_3_0;
    }

    FunctionDeclaration(AST ast) {
        super(ast);
    }

    @Override
    final List internalStructuralPropertiesForType(int apiLevel) {
        return FunctionDeclaration.propertyDescriptors(apiLevel);
    }

    @Override
    final int internalGetSetIntProperty(SimplePropertyDescriptor property, boolean get, int value) {
        if (property == MODIFIERS_PROPERTY) {
            if (get) {
                return this.getModifiers();
            }
            this.internalSetModifiers(value);
            return 0;
        }
        if (property == EXTRA_DIMENSIONS_PROPERTY) {
            if (get) {
                return this.getExtraDimensions();
            }
            this.setExtraDimensions(value);
            return 0;
        }
        return super.internalGetSetIntProperty(property, get, value);
    }

    @Override
    final boolean internalGetSetBooleanProperty(SimplePropertyDescriptor property, boolean get, boolean value) {
        if (property == CONSTRUCTOR_PROPERTY) {
            if (get) {
                return this.isConstructor();
            }
            this.setConstructor(value);
            return false;
        }
        return super.internalGetSetBooleanProperty(property, get, value);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == JAVADOC_PROPERTY) {
            if (get) {
                return this.getJavadoc();
            }
            this.setJavadoc((JSdoc)child);
            return null;
        }
        if (property == NAME_PROPERTY) {
            if (get) {
                return this.getName();
            }
            this.setName((SimpleName)child);
            return null;
        }
        if (property == RETURN_TYPE_PROPERTY) {
            if (get) {
                return this.getReturnType();
            }
            this.setReturnType((Type)child);
            return null;
        }
        if (property == RETURN_TYPE2_PROPERTY) {
            if (get) {
                return this.getReturnType2();
            }
            this.setReturnType2((Type)child);
            return null;
        }
        if (property == BODY_PROPERTY) {
            if (get) {
                return this.getBody();
            }
            this.setBody((Block)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    final List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == MODIFIERS2_PROPERTY) {
            return this.modifiers();
        }
        if (property == PARAMETERS_PROPERTY) {
            return this.parameters();
        }
        if (property == THROWN_EXCEPTIONS_PROPERTY) {
            return this.thrownExceptions();
        }
        return super.internalGetChildListProperty(property);
    }

    @Override
    final ChildPropertyDescriptor internalJavadocProperty() {
        return JAVADOC_PROPERTY;
    }

    @Override
    final ChildListPropertyDescriptor internalModifiers2Property() {
        return MODIFIERS2_PROPERTY;
    }

    @Override
    final SimplePropertyDescriptor internalModifiersProperty() {
        return MODIFIERS_PROPERTY;
    }

    @Override
    final int getNodeType0() {
        return 31;
    }

    @Override
    ASTNode clone0(AST target) {
        FunctionDeclaration result = new FunctionDeclaration(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setJavadoc((JSdoc)ASTNode.copySubtree(target, this.getJavadoc()));
        if (this.ast.apiLevel == 2) {
            result.internalSetModifiers(this.getModifiers());
            result.setReturnType((Type)ASTNode.copySubtree(target, this.getReturnType()));
        }
        if (this.ast.apiLevel >= 3) {
            result.modifiers().addAll(ASTNode.copySubtrees(target, this.modifiers()));
            result.setReturnType2((Type)ASTNode.copySubtree(target, this.getReturnType2()));
        }
        result.setConstructor(this.isConstructor());
        result.setExtraDimensions(this.getExtraDimensions());
        SimpleName name = this.getName();
        if (name != null) {
            result.setName((SimpleName)name.clone(target));
        }
        result.parameters().addAll(ASTNode.copySubtrees(target, this.parameters()));
        result.thrownExceptions().addAll(ASTNode.copySubtrees(target, this.thrownExceptions()));
        result.setBody((Block)ASTNode.copySubtree(target, this.getBody()));
        return result;
    }

    @Override
    final boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChild(visitor, this.getJavadoc());
            if (this.ast.apiLevel == 2) {
                this.acceptChild(visitor, this.getReturnType());
            } else {
                this.acceptChildren(visitor, this.modifiers);
                this.acceptChild(visitor, this.getReturnType2());
            }
            this.acceptChild(visitor, this.getName());
            this.acceptChildren(visitor, this.parameters);
            this.acceptChildren(visitor, this.thrownExceptions);
            this.acceptChild(visitor, this.getBody());
        }
        visitor.endVisit(this);
    }

    public boolean isConstructor() {
        return this.isConstructor;
    }

    public void setConstructor(boolean isConstructor) {
        this.preValueChange(CONSTRUCTOR_PROPERTY);
        this.isConstructor = isConstructor;
        this.postValueChange(CONSTRUCTOR_PROPERTY);
    }

    public SimpleName getName() {
        return this.methodName;
    }

    public void setName(SimpleName methodName) {
        SimpleName oldChild = this.methodName;
        this.preReplaceChild(oldChild, methodName, NAME_PROPERTY);
        this.methodName = methodName;
        this.postReplaceChild(oldChild, methodName, NAME_PROPERTY);
    }

    public List parameters() {
        return this.parameters;
    }

    public boolean isVarargs() {
        if (this.modifiers == null) {
            this.unsupportedIn2();
        }
        if (this.parameters().isEmpty()) {
            return false;
        }
        SingleVariableDeclaration v = (SingleVariableDeclaration)this.parameters().get(this.parameters().size() - 1);
        return v.isVarargs();
    }

    public List thrownExceptions() {
        return this.thrownExceptions;
    }

    public Type getReturnType() {
        return this.internalGetReturnType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Type internalGetReturnType() {
        this.supportedOnlyIn2();
        if (this.returnType == null) {
            FunctionDeclaration functionDeclaration = this;
            synchronized (functionDeclaration) {
                if (this.returnType == null) {
                    this.preLazyInit();
                    this.returnType = this.ast.newPrimitiveType(PrimitiveType.VOID);
                    this.postLazyInit(this.returnType, RETURN_TYPE_PROPERTY);
                }
            }
        }
        return this.returnType;
    }

    public void setReturnType(Type type) {
        this.internalSetReturnType(type);
    }

    void internalSetReturnType(Type type) {
        this.supportedOnlyIn2();
        if (type == null) {
            throw new IllegalArgumentException();
        }
        Type oldChild = this.returnType;
        this.preReplaceChild(oldChild, type, RETURN_TYPE_PROPERTY);
        this.returnType = type;
        this.postReplaceChild(oldChild, type, RETURN_TYPE_PROPERTY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type getReturnType2() {
        this.unsupportedIn2();
        if (this.returnType == null && !this.returnType2Initialized) {
            FunctionDeclaration functionDeclaration = this;
            synchronized (functionDeclaration) {
                if (this.returnType == null && !this.returnType2Initialized) {
                    this.preLazyInit();
                    this.returnType = this.ast.newPrimitiveType(PrimitiveType.VOID);
                    this.returnType2Initialized = true;
                    this.postLazyInit(this.returnType, RETURN_TYPE2_PROPERTY);
                }
            }
        }
        return this.returnType;
    }

    public void setReturnType2(Type type) {
        this.unsupportedIn2();
        this.returnType2Initialized = true;
        Type oldChild = this.returnType;
        this.preReplaceChild(oldChild, type, RETURN_TYPE2_PROPERTY);
        this.returnType = type instanceof InferredType && ((InferredType)type).getType() == null ? null : type;
        this.postReplaceChild(oldChild, type, RETURN_TYPE2_PROPERTY);
    }

    public int getExtraDimensions() {
        return this.extraArrayDimensions;
    }

    public void setExtraDimensions(int dimensions) {
        if (dimensions < 0) {
            throw new IllegalArgumentException();
        }
        this.preValueChange(EXTRA_DIMENSIONS_PROPERTY);
        this.extraArrayDimensions = dimensions;
        this.postValueChange(EXTRA_DIMENSIONS_PROPERTY);
    }

    public Block getBody() {
        return this.optionalBody;
    }

    public void setBody(Block body) {
        Block oldChild = this.optionalBody;
        this.preReplaceChild(oldChild, body, BODY_PROPERTY);
        this.optionalBody = body;
        this.postReplaceChild(oldChild, body, BODY_PROPERTY);
    }

    public IFunctionBinding resolveBinding() {
        return this.ast.getBindingResolver().resolveMethod(this);
    }

    @Override
    int memSize() {
        return super.memSize() + 36;
    }

    @Override
    int treeSize() {
        return this.memSize() + (this.optionalDocComment == null ? 0 : this.getJavadoc().treeSize()) + (this.modifiers == null ? 0 : this.modifiers.listSize()) + (this.methodName == null ? 0 : this.getName().treeSize()) + (this.returnType == null ? 0 : this.returnType.treeSize()) + this.parameters.listSize() + this.thrownExceptions.listSize() + (this.optionalBody == null ? 0 : this.getBody().treeSize());
    }
}

