/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.variables.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import oracle.eclipse.tools.application.common.services.documentservices.IImplicitVariableProvider;
import oracle.eclipse.tools.application.common.services.variables.IVariablesCache;
import oracle.eclipse.tools.application.common.services.variables.ImplicitVariable;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.common.services.util.HashCodeUtil;
import oracle.eclipse.tools.common.services.util.SerializationUtil;
import oracle.eclipse.tools.common.util.ObjectUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

public abstract class VariablesCache
implements IVariablesCache,
Serializable {
    private static final long serialVersionUID = 1L;
    private final IResource resource;
    private final List<Variable> variables = new LinkedList<Variable>();
    private long modificationTimestamp = -1L;

    public VariablesCache(IResource resource) {
        this.resource = resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Variable variable) {
        List<Variable> list = this.variables;
        synchronized (list) {
            this.variables.add(variable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Variable variable) {
        List<Variable> list = this.variables;
        synchronized (list) {
            this.variables.remove(variable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        List<Variable> list = this.variables;
        synchronized (list) {
            this.variables.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Variable> getVariables() {
        List<Variable> list = this.variables;
        synchronized (list) {
            return Collections.unmodifiableList(new LinkedList<Variable>(this.variables));
        }
    }

    @Override
    public IResource getResource() {
        return this.resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        List<Variable> list = this.variables;
        synchronized (list) {
            return this.resource.getProjectRelativePath() + " [" + this.variables.size() + "]";
        }
    }

    @Override
    public long getModificationTimestamp() {
        return this.modificationTimestamp;
    }

    @Override
    public void updateModificationStamp(long timeStamp) {
        this.modificationTimestamp = timeStamp;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof VariablesCache)) {
            return false;
        }
        VariablesCache other = (VariablesCache)obj;
        return ObjectUtil.areEqual((Object)this.getResource(), (Object)other.getResource()) && ObjectUtil.areEqual(this.getVariables(), other.getVariables()) && this.getModificationTimestamp() == other.getModificationTimestamp();
    }

    public int hashCode() {
        HashCodeUtil hcu = HashCodeUtil.newInstance();
        hcu.hash((Object)this.resource);
        hcu.hash(this.variables);
        hcu.hash(this.modificationTimestamp);
        return hcu.getHashCode();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        SerializationUtil su = SerializationUtil.forOutput((ObjectOutputStream)out);
        su.writeResource(this.resource);
        LinkedList<Variable> explicitVars = new LinkedList<Variable>();
        for (Variable var : this.variables) {
            if (var instanceof ImplicitVariable) continue;
            explicitVars.add(var);
        }
        out.writeObject(explicitVars);
        out.writeLong(this.modificationTimestamp);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, IllegalArgumentException, IllegalAccessException {
        IImplicitVariableProvider provider;
        IDocument document;
        SerializationUtil su = SerializationUtil.forInput((ObjectInputStream)in);
        su.readFinalResourceFromStream((Object)this, "resource");
        su.readFinalFieldFromStream((Object)this, "variables", List.class);
        if (this.resource.exists() && this.resource.getType() == 1 && (document = (IDocument)((IFile)this.resource).getAdapter(IDocument.class)) != null && (provider = (IImplicitVariableProvider)document.getAdapter(IImplicitVariableProvider.class)) != null) {
            List<Variable> implicitVariables = provider.getImplicitVariables();
            for (Variable implicitVariable : implicitVariables) {
                this.variables.add(implicitVariable);
            }
        }
        this.modificationTimestamp = in.readLong();
    }
}

