/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.variables.internal;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import oracle.eclipse.tools.application.common.services.documentservices.IImplicitVariableProvider;
import oracle.eclipse.tools.application.common.services.variables.IVariablesCache;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.common.services.dependency.artifact.IResourceContext;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.ContentTypeCollectionFilter;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.ICollectionFilter;
import oracle.eclipse.tools.common.services.dependency.artifact.discovery.AbstractSimpleDiscoveryParticipant;
import oracle.eclipse.tools.common.services.dependency.artifact.discovery.IDiscoveryParticipant;
import oracle.eclipse.tools.common.services.dependency.artifact.discovery.IResourceDiscoveryContext;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.IVisitableDOMModel;
import oracle.eclipse.tools.common.services.document.IDocument;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;

public class ImplicitVariableDiscoveryParticipant
extends AbstractSimpleDiscoveryParticipant
implements IDiscoveryParticipant {
    private static final String CTYPE_JSPSOURCE = "org.eclipse.jst.jsp.core.jspsource";
    private static final String CTYPE_JSPFRAGMENTSOURCE = "org.eclipse.jst.jsp.core.jspfragmentsource";
    private static final String CTYPE_HTMLSOURCE = "org.eclipse.wst.html.core.htmlsource";
    private static final ICollectionFilter JSP_FILTER;

    static {
        LinkedHashSet<String> types = new LinkedHashSet<String>(2, 1.0f);
        types.add(CTYPE_JSPSOURCE);
        types.add(CTYPE_JSPFRAGMENTSOURCE);
        types.add(CTYPE_HTMLSOURCE);
        JSP_FILTER = new ContentTypeCollectionFilter(Collections.unmodifiableSet(types));
    }

    public void discover(IResourceDiscoveryContext context, IProgressMonitor monitor) {
        IVariablesCache cache;
        if (JSP_FILTER.match((IResourceContext)context) && (cache = (IVariablesCache)context.getAdapter(IVariablesCache.class)) != null) {
            this.addImplicitVars(cache);
        }
    }

    public void discoverFromExistingModel(IResourceDiscoveryContext context, IVisitableDOMModel model, IProgressMonitor monitor) {
        IVariablesCache cache;
        if (JSP_FILTER.match((IResourceContext)context) && (cache = (IVariablesCache)context.getAdapter(IVariablesCache.class)) != null) {
            this.addImplicitVars(cache);
        }
    }

    private void addImplicitVars(IVariablesCache cache) {
        IImplicitVariableProvider provider;
        IDocument document;
        IResource resource = cache.getResource();
        if (resource.getType() == 1 && (document = (IDocument)((IFile)resource).getAdapter(IDocument.class)) != null && (provider = (IImplicitVariableProvider)document.getAdapter(IImplicitVariableProvider.class)) != null) {
            List<Variable> implicitVariables = provider.getImplicitVariables();
            for (Variable variable : implicitVariables) {
                cache.add(variable);
            }
        }
    }
}

