/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.variables.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.application.common.services.variables.IFileVariablesCache;
import oracle.eclipse.tools.application.common.services.variables.IProjectVariablesCache;
import oracle.eclipse.tools.application.common.services.variables.ValueReference;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.application.common.services.variables.internal.IValueReferencePersistenceHandler;
import oracle.eclipse.tools.application.common.services.variables.internal.ProjectVariablesCache;
import oracle.eclipse.tools.application.common.services.variables.internal.ValueReferencePersistenceHandlerFactory;
import oracle.eclipse.tools.application.common.services.variables.internal.VariablesCache;
import oracle.eclipse.tools.common.services.util.HashCodeUtil;
import oracle.eclipse.tools.common.services.util.SerializationUtil;
import oracle.eclipse.tools.common.util.ObjectUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

public class FileVariablesCache
extends VariablesCache
implements IFileVariablesCache,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Set<ValueReference> references = new LinkedHashSet<ValueReference>();
    private final IProjectVariablesCache projectCache;

    public FileVariablesCache(IFile file, IProjectVariablesCache projectCache) {
        super((IResource)file);
        assert (file != null);
        this.projectCache = projectCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileVariablesCache(FileVariablesCache primingCache) {
        super((IResource)primingCache.getResource());
        List<Variable> primingCacheVariables;
        this.projectCache = primingCache.projectCache;
        Set<ValueReference> set = primingCache.references;
        synchronized (set) {
            this.references.addAll(primingCache.references);
        }
        List<Variable> list = primingCacheVariables = primingCache.internalGetFileVariables();
        synchronized (list) {
            for (Variable var : primingCacheVariables) {
                this.add(var);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(ValueReference reference) {
        Set<ValueReference> set = this.references;
        synchronized (set) {
            this.references.add(reference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        super.clear();
        Set<ValueReference> set = this.references;
        synchronized (set) {
            this.references.clear();
        }
    }

    @Override
    public List<Variable> getVariables() {
        LinkedList<Variable> vars = new LinkedList<Variable>();
        vars.addAll(super.getVariables());
        if (this.projectCache != null) {
            vars.addAll(this.projectCache.getVariables());
        }
        return Collections.unmodifiableList(vars);
    }

    private List<Variable> internalGetFileVariables() {
        return super.getVariables();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasReference(ValueReference valRef) {
        if (valRef == null) return false;
        Set<ValueReference> set = this.references;
        synchronized (set) {
            ValueReference ref;
            Iterator<ValueReference> iterator = this.references.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!valRef.contains(ref = iterator.next()));
            return true;
        }
    }

    public IFile getResource() {
        return (IFile)super.getResource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ValueReference> getReferences() {
        Set<ValueReference> set = this.references;
        synchronized (set) {
            return Collections.unmodifiableSet(new LinkedHashSet<ValueReference>(this.references));
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof FileVariablesCache)) {
            return false;
        }
        FileVariablesCache other = (FileVariablesCache)obj;
        return super.equals(obj) && ObjectUtil.areEqual(this.getReferences(), other.getReferences());
    }

    @Override
    public int hashCode() {
        HashCodeUtil hcu = HashCodeUtil.newInstance();
        hcu.hash(super.hashCode());
        hcu.hash(this.references);
        return hcu.getHashCode();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        ArrayList<IValueReferencePersistenceHandler> refHandlers = new ArrayList<IValueReferencePersistenceHandler>(this.references.size());
        for (ValueReference ref : this.references) {
            refHandlers.add(ValueReferencePersistenceHandlerFactory.create((IResource)this.getResource(), ref));
        }
        out.writeObject(refHandlers);
        out.writeObject(this.projectCache);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, IllegalArgumentException, IllegalAccessException {
        SerializationUtil su = SerializationUtil.forInput((ObjectInputStream)in);
        Object value = in.readObject();
        LinkedHashSet<ValueReference> refs = new LinkedHashSet<ValueReference>();
        if (value instanceof List) {
            List refHandlers = (List)value;
            for (IValueReferencePersistenceHandler handler : refHandlers) {
                refs.add(handler.getValueReference());
            }
        } else {
            throw new IllegalStateException("Current data in stream is not of correct type.");
        }
        su.setFinalField((Object)this, "references", Set.class, refs);
        assert (this.getResource() != null);
        assert (this.getResource().getType() == 1);
        su.readFinalFieldFromStream((Object)this, "projectCache", ProjectVariablesCache.class);
    }
}

