/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.variables.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import oracle.eclipse.tools.application.common.services.variables.VariablesController;
import oracle.eclipse.tools.common.services.dependency.artifact.discovery.AbstractSimpleDiscoveryParticipant;
import oracle.eclipse.tools.common.services.dependency.artifact.discovery.IDiscoveryContext;
import oracle.eclipse.tools.common.services.dependency.artifact.discovery.IDiscoveryParticipant;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.common.util.wtp.WtpProjectUtil;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class DataTypeUnloadDiscoveryParticipant
extends AbstractSimpleDiscoveryParticipant
implements IDiscoveryParticipant {
    private static final String CTYPE_JSPSOURCE = "org.eclipse.jst.jsp.core.jspsource";
    private static final String CTYPE_JSPFRAGMENTSOURCE = "org.eclipse.jst.jsp.core.jspfragmentsource";
    private static final String CTYPE_HTMLSOURCE = "org.eclipse.wst.html.core.htmlsource";
    private static final Set<String> CONTENT_TYPE_IDS;

    static {
        LinkedHashSet<String> types = new LinkedHashSet<String>(2, 1.0f);
        types.add(CTYPE_JSPSOURCE);
        types.add(CTYPE_JSPFRAGMENTSOURCE);
        types.add(CTYPE_HTMLSOURCE);
        CONTENT_TYPE_IDS = Collections.unmodifiableSet(types);
    }

    public void startDiscovery(IDiscoveryContext context, IProgressMonitor monitor) {
        if (!context.isWorkingCopy()) {
            Set<IProject> projects = this.getAllDependingProjectsFor(context.getProject());
            this.resetDataTypesForAll(projects);
        }
    }

    private void resetDataTypesForAll(Collection<IProject> projects) {
        for (IProject project : projects) {
            VariablesController.getInstance().resetDataTypes(project);
        }
    }

    private Set<IProject> getAllDependingProjectsFor(IProject project) {
        IVirtualComponent c;
        int n;
        int n2;
        IVirtualComponent[] iVirtualComponentArray;
        IVirtualComponent[] refComponents;
        HashSet<IProject> result = new HashSet<IProject>();
        result.add(project);
        IProject ear = null;
        if (WtpProjectUtil.isEarProject((IProject)project)) {
            ear = project;
        } else {
            IVirtualComponent pc = ComponentCore.createComponent((IProject)project);
            if (pc != null) {
                iVirtualComponentArray = refComponents = pc.getReferencingComponents();
                n2 = refComponents.length;
                n = 0;
                while (n < n2) {
                    c = iVirtualComponentArray[n];
                    result.add(c.getProject());
                    if (WtpProjectUtil.isEarProject((IProject)c.getProject())) {
                        ear = c.getProject();
                    }
                    ++n;
                }
            }
        }
        if (ear != null) {
            IVirtualReference[] references;
            IVirtualComponent earc = ComponentCore.createComponent((IProject)ear);
            iVirtualComponentArray = refComponents = earc.getReferencingComponents();
            n2 = refComponents.length;
            n = 0;
            while (n < n2) {
                c = iVirtualComponentArray[n];
                result.add(c.getProject());
                ++n;
            }
            IVirtualReference[] iVirtualReferenceArray = references = earc.getReferences();
            int n3 = references.length;
            n2 = 0;
            while (n2 < n3) {
                IVirtualReference reference = iVirtualReferenceArray[n2];
                IProject p = reference.getReferencedComponent().getProject();
                result.add(p);
                ++n2;
            }
        }
        return result;
    }

    protected boolean isWebPageContentType(IResource resource) {
        block4: {
            if (resource.getType() == 1 && resource.exists()) {
                try {
                    IContentType contentType;
                    IContentDescription contentDesc = ((IFile)resource).getContentDescription();
                    if (contentDesc != null && (contentType = contentDesc.getContentType()) != null && CONTENT_TYPE_IDS.contains(contentType.getId())) {
                        return true;
                    }
                }
                catch (CoreException e) {
                    if (e instanceof ResourceException) break block4;
                    LoggingService.logException((String)"oracle.eclipse.tools.application.common.services", (CoreException)e);
                }
            }
        }
        return false;
    }
}

