/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.variables;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import oracle.eclipse.tools.application.common.services.techextservices.IDataTypeIntrospector;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.JDTDataType;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.services.util.SerializationUtil;
import org.eclipse.jdt.core.IType;

public class WildcardDataType
extends JDTDataType {
    private static final long serialVersionUID = -3995531882734693787L;
    private final String _originalWildcard;

    WildcardDataType(IDataTypeIntrospector introspector, IType type, String typeName, String originalWildcard, DataType componentType, Project project, int arrayDimensions) {
        super(introspector, type, typeName, componentType, project, false, arrayDimensions);
        this._originalWildcard = originalWildcard;
    }

    @Override
    public boolean isWildcard() {
        return true;
    }

    public String getOriginalWildcard() {
        return this._originalWildcard;
    }

    @Override
    public String getDisplayName(boolean abbreviated) {
        if (abbreviated) {
            if (this.getOriginalWildcard() == null) {
                return null;
            }
            int index = this.getOriginalWildcard().lastIndexOf(46);
            if (index < 0) {
                return this.getOriginalWildcard();
            }
            return this.getOriginalWildcard().substring(index + 1).replace('$', '.');
        }
        return this.getOriginalWildcard().replace('$', '.');
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeChars(this._originalWildcard);
    }

    private void readObject(ObjectInputStream in) throws IllegalArgumentException, IOException, ClassNotFoundException, IllegalAccessException {
        SerializationUtil su = SerializationUtil.forInput((ObjectInputStream)in);
        su.readFinalFieldFromStream((Object)this, "_originalWildcard", String.class);
    }

    private Object readResolve() {
        JDTDataType readResolvedType = null;
        if (this.isWildcard()) {
            readResolvedType = JDTDataType.instanceForWildcard(this.getIntrospector(), this.getType(), this._originalWildcard, this.getRawComponentType(), this.getArrayDimensions());
        }
        return readResolvedType == null ? this : readResolvedType;
    }
}

