/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.variables;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.application.common.services.variables.IVariablesReadCache;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.application.common.services.variables.VariableQuery;

public class VariablesIterator
implements Iterator<Variable> {
    private static final boolean PREVENT_DUPLICATE_VAR_NAME = true;
    private final List<Variable> variables;
    private final Map<String, List<Variable>> nameIndex;
    private final Iterator<Variable> varIter;
    private final IVariablesReadCache cache;

    VariablesIterator(IVariablesReadCache cache) {
        this(cache, null);
    }

    VariablesIterator(IVariablesReadCache cache, VariableQuery.QueryMatcher matcher) {
        if (cache == null) {
            throw new IllegalArgumentException("Cache must not be null.");
        }
        this.cache = cache;
        this.variables = new LinkedList<Variable>();
        this.nameIndex = new HashMap<String, List<Variable>>();
        this.filterVars(matcher);
        this.varIter = this.variables.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.varIter.hasNext();
    }

    @Override
    public Variable next() {
        return this.varIter.next();
    }

    public List<Variable> getVariables() {
        return new ArrayList<Variable>(this.variables);
    }

    public Map<String, List<Variable>> getNameIndex() {
        return Collections.unmodifiableMap(this.nameIndex);
    }

    private void filterVars(VariableQuery.QueryMatcher matcher) {
        for (Variable var : this.cache.getVariables()) {
            this.addVariable(var, matcher, false);
        }
    }

    private void addVariable(Variable var, VariableQuery.QueryMatcher matcher, boolean preventDupName) {
        List<Variable> indexed = this.nameIndex.get(var.getName());
        if (!(matcher != null || preventDupName && indexed != null)) {
            this.variables.add(var);
            this.indexVar(indexed, var);
        } else if (matcher != null && (!preventDupName || indexed == null) && matcher.matches(var)) {
            this.variables.add(var);
            this.indexVar(indexed, var);
        }
    }

    private void indexVar(List<Variable> indexed, Variable var) {
        List<Variable> variablesList = indexed;
        if (variablesList == null) {
            variablesList = new ArrayList<Variable>();
            this.nameIndex.put(var.getName(), variablesList);
        }
        variablesList.add(var);
    }

    @Override
    public void remove() {
        assert (false);
    }
}

