/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.variables;

import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import oracle.eclipse.tools.application.common.services.collection.StructuredDocumentRangeFactory;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.DocumentVariableQuery;
import oracle.eclipse.tools.application.common.services.variables.ELExpression;
import oracle.eclipse.tools.application.common.services.variables.JavaResourceBundleDataType;
import oracle.eclipse.tools.application.common.services.variables.MethodInfo;
import oracle.eclipse.tools.application.common.services.variables.ValueReference;
import oracle.eclipse.tools.application.common.services.variables.ValueReferenceELParser;
import oracle.eclipse.tools.application.common.services.variables.ValueReferenceFactory;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.Range;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.TypePropertyReference;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.CollectionContext;
import oracle.eclipse.tools.common.services.document.FilePositionContext;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.common.services.refactoring.RefactoringUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.jsf.context.IModelContext;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

public final class VariableReferenceCollectionHelper {
    public static List<ValueReference> collectTypeReferenceFromElExpression(IArtifact artifact, IFile file, CollectionContext collectionContext, String collectorID, IDOMNode node, String expr) {
        ValueReferenceELParser parser = new ValueReferenceELParser();
        ELExpression expression = parser.getELExpression(expr);
        if (expression == null) {
            return null;
        }
        String elText = expression.getElText();
        if (elText == null || "".equals(elText)) {
            return null;
        }
        IDocument document = (IDocument)Platform.getAdapterManager().loadAdapter((Object)file, IDocument.class.getName());
        DocumentVariableQuery query = new DocumentVariableQuery(document, -1);
        ValueReferenceFactory vrFactory = new ValueReferenceFactory();
        StructuredDocumentRangeFactory rangeFactory = new StructuredDocumentRangeFactory();
        Range range = null;
        if (node instanceof IDOMAttr) {
            range = rangeFactory.createRangeForAttributeValue((IDOMAttr)node);
        } else if (node instanceof IDOMElement) {
            range = rangeFactory.createRange((IDOMElement)node);
        } else {
            return null;
        }
        List<ValueReference> refs = vrFactory.createValueReference(elText, query, range, true);
        if (refs == null) {
            return null;
        }
        FilePositionContext modelContext = new FilePositionContext(file);
        for (ValueReference ref : refs) {
            VariableReferenceCollectionHelper.collectValueReference(artifact, file, collectionContext, collectorID, (IModelContext)modelContext, ref);
        }
        return Collections.unmodifiableList(refs);
    }

    public static final boolean collectValueReference(IArtifact artifact, IFile file, CollectionContext collectionContext, String collectorID, IModelContext modelContext, ValueReference ref) {
        Range refLocation;
        Variable var = ref.getVariable();
        String varName = var.getName();
        if (varName != null && (varName.equalsIgnoreCase("controllerContext") || varName.equalsIgnoreCase("bindingContext") || varName.equalsIgnoreCase("bindings"))) {
            return false;
        }
        DataType varType = var.getType();
        DataType type = null;
        if (varType != null) {
            type = varType.isEnumerable() ? varType.getComponentType() : varType;
        }
        if ((refLocation = ref.getLocation()) == null) {
            return false;
        }
        String refTypeString = RefactoringUtil.getRangeString((IFile)file, (Range)refLocation);
        int start = refTypeString.indexOf(var.getName());
        Range varRange = new Range(refLocation.getOffset() + (long)start, (long)var.getName().length());
        ResourceLocation varLocation = new ResourceLocation((IResource)file, varRange);
        String fieldName = ref.getFieldName();
        if (!(type == null || type instanceof JavaResourceBundleDataType || type.isUnknown() || type.isPrimitiveType() || type.getDisplayName().startsWith(".java"))) {
            if (fieldName != null) {
                StringTokenizer tokenizer = new StringTokenizer(fieldName, ".");
                return VariableReferenceCollectionHelper.collectPropertyReferences(varLocation, tokenizer.nextToken(), tokenizer, type, artifact, file, ref, modelContext, collectionContext, collectorID);
            }
            collectionContext.addTypeReference(artifact, file.getProject(), type.getName(), varLocation, false, collectorID);
            return true;
        }
        return false;
    }

    private static boolean collectPropertyReferences(ResourceLocation typeLocation, String prop, StringTokenizer tokenizer, DataType propOwnerType, IArtifact ownerArtifact, IFile file, ValueReference ref, IModelContext modelContext, CollectionContext collectionContext, String collecterID) {
        if (prop == null) {
            collectionContext.addTypeReference(ownerArtifact, file.getProject(), propOwnerType.getName(), typeLocation, false, collecterID);
            return false;
        }
        Range range = typeLocation.getRange();
        ResourceLocation propLocation = new ResourceLocation((IResource)file, new Range(range.getEndOffset() + 1L, (long)prop.length()));
        TypePropertyReference propRefArtifact = new TypePropertyReference(propLocation, propLocation, prop, ownerArtifact, collecterID);
        collectionContext.addArtifact((IArtifact)propRefArtifact, collecterID);
        DataType propDataType = null;
        boolean matched = false;
        List<DataType.Field> fields = propOwnerType.getFields(modelContext);
        for (DataType.Field field : fields) {
            if (field == null || !field.getName().equals(prop)) continue;
            matched = true;
            propDataType = field.getType();
            if (propOwnerType instanceof JavaResourceBundleDataType || propOwnerType.isUnknown() || propOwnerType.isPrimitiveType() || propOwnerType.getName().startsWith("java.")) continue;
            collectionContext.addTypeReference((IArtifact)propRefArtifact, file.getProject(), propOwnerType.getName(), typeLocation, false, collecterID);
            return true;
        }
        if (!matched) {
            List<MethodInfo> methods = propOwnerType.getPublicMethods();
            for (MethodInfo methodInfo : methods) {
                if (!methodInfo.getMethodName().equals(prop)) continue;
                matched = true;
                propDataType = methodInfo.getReturnedType();
                if (propOwnerType instanceof JavaResourceBundleDataType || propOwnerType.isUnknown() || propOwnerType.isPrimitiveType() || propOwnerType.getName().startsWith("java.")) continue;
                collectionContext.addTypeReference((IArtifact)propRefArtifact, file.getProject(), propOwnerType.getName(), typeLocation, false, collecterID);
                return true;
            }
        } else if (tokenizer.hasMoreTokens()) {
            if (propDataType != null && propDataType.isEnumerable()) {
                propDataType = propDataType.getComponentType();
            }
            return VariableReferenceCollectionHelper.collectPropertyReferences(propLocation, tokenizer.nextToken(), tokenizer, propDataType, ownerArtifact, file, ref, modelContext, collectionContext, collecterID);
        }
        return false;
    }
}

