/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.variables;

import java.util.EnumSet;
import oracle.eclipse.tools.application.common.services.variables.SymbolUtil;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.application.common.services.variables.VariableQuery;
import org.eclipse.jst.jsf.context.IModelContext;

public class VariableInScopeMatcher
implements VariableQuery.QueryMatcher {
    private final IModelContext _context;
    private final EnumSet<Variable.SCOPE> _matchScopes;
    private static final EnumSet<Variable.SCOPE> AllValidScopes = EnumSet.of(Variable.SCOPE.AT_BEGIN_SCOPE, Variable.SCOPE.AT_END_SCOPE, Variable.SCOPE.NESTED_SCOPE, Variable.SCOPE.NONE_SCOPE);

    public VariableInScopeMatcher(IModelContext context, EnumSet<Variable.SCOPE> matchScopes) {
        this._context = context;
        this._matchScopes = matchScopes;
    }

    public VariableInScopeMatcher(IModelContext context) {
        this(context, AllValidScopes);
    }

    public boolean matches(Variable variable) {
        if (this._matchScopes.contains((Object)variable.getScope())) {
            switch (variable.getScope()) {
                case AT_BEGIN_SCOPE: 
                case AT_END_SCOPE: 
                case NESTED_SCOPE: {
                    return variable.isInScope(SymbolUtil.getOffset(this._context));
                }
            }
            return true;
        }
        return true;
    }
}

