/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.variables;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.application.common.services.variables.ValueReference;

public class ValueReferencePath {
    public static final ValueReferencePath NO_PATH = new ValueReferencePath();
    private final List<ValueReference> _path;
    private final ValueReference _fromReference;
    private final ValueReference _toReference;

    public ValueReferencePath(List<ValueReference> path, ValueReference fromReference, ValueReference toReference) {
        if (path == null || fromReference == null || toReference == null) {
            throw new NullPointerException("Args must not be null");
        }
        this._path = path;
        this._fromReference = fromReference;
        this._toReference = toReference;
    }

    private ValueReferencePath() {
        this._path = Collections.EMPTY_LIST;
        this._fromReference = new ValueReference(null);
        this._toReference = new ValueReference(null);
    }

    public final List<ValueReference> getIntermediatePath() {
        return this._path;
    }

    public final List<ValueReference> getFullPath() {
        ArrayList<ValueReference> path = new ArrayList<ValueReference>(this._path.size() + 2);
        path.add(this._fromReference);
        path.addAll(this._path);
        if (!this._fromReference.equals(this._toReference)) {
            path.add(this._toReference);
        }
        return path;
    }

    public final ValueReference getFromReference() {
        return this._fromReference;
    }

    public final ValueReference getToReference() {
        return this._toReference;
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (!(obj instanceof ValueReferencePath)) {
            return false;
        }
        ValueReferencePath otherPath = (ValueReferencePath)obj;
        return this._fromReference.equals(otherPath._fromReference) && this._toReference.equals(otherPath._toReference) && this._path.equals(otherPath._path);
    }

    public int hashCode() {
        return this._fromReference.hashCode() ^ this._toReference.hashCode() ^ this._path.hashCode();
    }
}

