/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.variables;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.ResolutionTime;
import oracle.eclipse.tools.application.common.services.variables.ValueReference;
import oracle.eclipse.tools.application.common.services.variables.ValueReferenceELParser;
import oracle.eclipse.tools.application.common.services.variables.ValueReferenceELParser2;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.application.common.services.variables.VariableQuery;
import oracle.eclipse.tools.common.services.dependency.artifact.Range;
import oracle.eclipse.tools.common.util.StringUtil;

public class ValueReferenceFactory {
    public ValueReference createValueReference(Variable var, List<String> fieldNames) {
        return this.createValueReference(var, fieldNames, null);
    }

    public ValueReference createValueReference(Variable var, List<String> fieldNames, Range range) {
        String fields = null;
        if (fieldNames.size() > 0) {
            fields = StringUtil.join(fieldNames, (char)'.');
        }
        return new ValueReference(var, fields, range);
    }

    public List<ValueReference> createValueReference(String elExpression, VariableQuery varQuery) {
        return this.createValueReference(elExpression, varQuery, null);
    }

    public List<ValueReference> createValueReference(String elExpression, VariableQuery varQuery, Range range) {
        return this.createValueReference(elExpression, varQuery, range, false);
    }

    public List<ValueReference> createValueReference(String elExpression, VariableQuery varQuery, Range range, boolean createMissingVariableIfNeeded) {
        ValueReferenceELParser parser = new ValueReferenceELParser();
        List<ValueReferenceELParser.ValueReferenceELExpr> expressions = parser.getExpressions(elExpression);
        if (expressions.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<ValueReference> valueRefs = new ArrayList<ValueReference>();
        for (ValueReferenceELParser.ValueReferenceELExpr expr : expressions) {
            List<Variable> foundVariables;
            String varName = expr.getModelObjectName();
            List<String> fields = expr.getPropertyObjectNames();
            if ((varName.equals("viewScope") || varName.equals("pageFlowScope") || varName.equals("backingBeanScope")) && fields.size() > 0) {
                varName = fields.get(0);
                if (fields.size() > 1) {
                    fields = fields.subList(1, fields.size());
                }
            }
            if (!(foundVariables = varQuery.findVariable(new VariableQuery.NameMatcher(varName))).isEmpty()) {
                valueRefs.add(this.createValueReference(foundVariables.get(0), fields, range));
                continue;
            }
            if (!createMissingVariableIfNeeded) continue;
            ValueReference unknownVarRef = this.createValueReference(new Variable(varName, DataType.getUnspecifiedType(), Variable.SCOPE.PAGE_SCOPE, ResolutionTime.NOT_AVAILABLE, null, null), fields, range);
            unknownVarRef.setUnknownVar();
            valueRefs.add(unknownVarRef);
        }
        return valueRefs;
    }

    public List<ValueReference> createValueReference2(String elExpression, VariableQuery varQuery, Range range, boolean createMissingVariableIfNeeded) {
        ValueReferenceELParser2 parser = new ValueReferenceELParser2();
        List<ValueReferenceELParser.ValueReferenceELExpr> expressions = parser.getExpressions(elExpression);
        if (expressions.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<ValueReference> valueRefs = new ArrayList<ValueReference>(2);
        for (ValueReferenceELParser.ValueReferenceELExpr expr : expressions) {
            List<Variable> foundVariables;
            String varName = expr.getModelObjectName();
            List<String> fields = expr.getPropertyObjectNames();
            if ((varName.equals("viewScope") || varName.equals("pageFlowScope") || varName.equals("backingBeanScope")) && fields.size() > 0) {
                varName = fields.get(0);
                if (fields.size() > 1) {
                    fields = fields.subList(1, fields.size());
                }
            }
            if (!(foundVariables = varQuery.findVariable(new VariableQuery.NameMatcher(varName))).isEmpty()) {
                valueRefs.add(this.createValueReference(foundVariables.get(0), fields, range));
                continue;
            }
            if (!createMissingVariableIfNeeded) continue;
            ValueReference unknownVarRef = this.createValueReference(new Variable(varName, DataType.getUnspecifiedType(), Variable.SCOPE.PAGE_SCOPE, ResolutionTime.NOT_AVAILABLE, null, null), fields, range);
            unknownVarRef.setUnknownVar();
            valueRefs.add(unknownVarRef);
        }
        return valueRefs;
    }
}

