/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.variables;

import java.net.MalformedURLException;
import java.net.URL;
import oracle.eclipse.tools.application.common.services.Activator;
import oracle.eclipse.tools.application.common.services.util.LogMgr;
import oracle.eclipse.tools.application.common.services.variables.Location;
import oracle.eclipse.tools.application.common.services.variables.Locator;
import oracle.eclipse.tools.application.common.services.variables.Marker;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.runtime.Plugin;

public class SimpleLocator
implements Locator {
    public static final String SIMPLE_LOCATOR_NAME = "simple";
    public static final String URL_ATTR = "location.url";
    public static final String OFFSET_ATTR = "location.offset";
    public static final String LENGTH_ATTR = "location.length";

    @Override
    public Location locate(Marker marker) {
        assert (marker != null) : "Cannot locate a null marker.";
        Location location = new Location();
        String urlString = marker.getAttributeValue(URL_ATTR);
        try {
            location.setUrl(new URL(urlString));
        }
        catch (MalformedURLException mue) {
            LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)mue, (String)("SimpleLocator Unable to convert marker with URL string " + urlString));
            return null;
        }
        String offsetStr = marker.getAttributeValue(OFFSET_ATTR);
        if (offsetStr != null) {
            String lengthStr = marker.getAttributeValue(LENGTH_ATTR);
            try {
                location.setOffset(Integer.parseInt(offsetStr));
                if (lengthStr != null) {
                    location.setLength(Integer.parseInt(lengthStr));
                }
            }
            catch (NumberFormatException nfe) {
                LogMgr.getUnhandledExceptionLogger().info("SimpleLocator Unable to convert marker with invalid number", nfe);
                return null;
            }
        }
        return location;
    }
}

