/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.variables;

import oracle.eclipse.tools.application.common.services.techextservices.IDataTypeIntrospector;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.JDTDataType;

public class PropertyDescriptor {
    private final JDTDataType type;
    private final String propertyName;
    private String readMethodName = null;
    private String writeMethodName = null;
    private String returnType = null;

    public PropertyDescriptor(JDTDataType type, String propertyName) {
        this.propertyName = propertyName;
        this.type = type;
    }

    public String getName() {
        return this.propertyName;
    }

    public void setReadMethodName(String name) {
        this.readMethodName = name;
    }

    public void setWriteMethodName(String name) {
        this.writeMethodName = name;
    }

    public String getReadMethodName() {
        return this.readMethodName;
    }

    public String getWriteMethodName() {
        return this.writeMethodName;
    }

    public void setReturnType(String type) {
        this.returnType = type;
    }

    public DataType getPropertyType() {
        IDataTypeIntrospector introspector = this.type.getIntrospector();
        if (introspector != null && this.returnType != null) {
            return introspector.introspect(this.returnType, null);
        }
        return DataType.getUnspecifiedType();
    }

    DataType getParentType() {
        return this.type;
    }
}

