/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.variables;

import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.application.common.services.techextservices.IDataTypeIntrospector;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.JavaDataType;
import oracle.eclipse.tools.common.services.project.Project;
import org.eclipse.jst.jsf.context.IModelContext;
import org.eclipse.jst.jsf.context.symbol.IMapTypeDescriptor;
import org.eclipse.jst.jsf.context.symbol.IObjectSymbol;
import org.eclipse.jst.jsf.context.symbol.ITypeDescriptor;

public class PopulatedMapJavaDataType
extends JavaDataType {
    private Map<String, IObjectSymbol> _values;
    private static final long serialVersionUID = 1L;

    public PopulatedMapJavaDataType(IDataTypeIntrospector introspector, Project project, Map<String, IObjectSymbol> values) {
        super(introspector, "java.util.Map", project);
        this._values = values;
    }

    public PopulatedMapJavaDataType(IDataTypeIntrospector introspector, Project project, IMapTypeDescriptor typeDesc) {
        super(introspector, "java.util.Map", project);
        this._values = typeDesc.getMapSource();
    }

    public final Map<String, IObjectSymbol> getValues() {
        return Collections.unmodifiableMap(this._values);
    }

    @Override
    public List<DataType.Field> getFields(IModelContext context) {
        ArrayList<DataType.Field> fields = new ArrayList<DataType.Field>();
        for (Map.Entry<String, IObjectSymbol> value : this._values.entrySet()) {
            ITypeDescriptor typeDescriptor = value.getValue().getTypeDescriptor();
            JavaDataType type = new JavaDataType(PopulatedMapJavaDataType.getSignature(typeDescriptor), this.getProject());
            JavaDataType.JavaField field = new JavaDataType.JavaField(value.getKey().toString(), type, null, null);
            fields.add(field);
        }
        return fields;
    }

    private static String getSignature(ITypeDescriptor typeDescriptor) {
        String signature = typeDescriptor.getTypeSignature();
        if (signature == null) {
            signature = typeDescriptor.getTypeSignatureDelegate();
        }
        return signature;
    }

    private void writeObject(ObjectOutputStream out) throws NotSerializableException {
        throw new NotSerializableException("Not serializable.");
    }

    private void readObject(ObjectInputStream in) throws NotSerializableException {
        throw new NotSerializableException("Not serializable.");
    }
}

