/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.variables;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.MethodInfo;
import oracle.eclipse.tools.application.common.services.variables.MethodReference;
import oracle.eclipse.tools.application.common.services.variables.ValueReference;
import oracle.eclipse.tools.application.common.services.variables.ValueReferenceELParser;
import oracle.eclipse.tools.application.common.services.variables.ValueReferenceFactory;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.application.common.services.variables.VariableQuery;
import oracle.eclipse.tools.common.services.project.Project;

public class MethodReferenceFactory {
    public MethodReference createMethodReference(ValueReference valRef, String methodName) {
        assert (valRef != null);
        assert (methodName != null);
        MethodInfo method = this.findMethodInfoByName(valRef, methodName);
        if (method != null) {
            return new MethodReference(valRef, method);
        }
        return null;
    }

    public MethodReference createMethodReference(ValueReference valRef, Project project, String methodName, String methodReturnTypeName, String[] methodParameterTypeNames) {
        assert (project != null);
        assert (methodReturnTypeName != null);
        assert (methodParameterTypeNames != null);
        MethodInfo method = new MethodInfo(project, methodName, methodReturnTypeName, methodParameterTypeNames);
        return new MethodReference(valRef, method);
    }

    public List<MethodReference> createMethodReference(String elExpression, VariableQuery varQuery) {
        ValueReferenceELParser parser = new ValueReferenceELParser();
        List<ValueReferenceELParser.ValueReferenceELExpr> expressions = parser.getExpressions(elExpression);
        if (expressions.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<MethodReference> methodRefs = new ArrayList<MethodReference>();
        ValueReferenceFactory valRefFactory = new ValueReferenceFactory();
        for (ValueReferenceELParser.ValueReferenceELExpr expr : expressions) {
            MethodReference methodRef = this.maybeCreateMethodReference(varQuery, valRefFactory, expr);
            if (methodRef == null) continue;
            methodRefs.add(methodRef);
        }
        return methodRefs;
    }

    public MethodReference maybeCreateMethodReference(VariableQuery varQuery, ValueReferenceFactory valRefFactory, ValueReferenceELParser.ValueReferenceELExpr expr) {
        List<Variable> foundVariables;
        String varName = expr.getModelObjectName();
        List<String> fieldsOrMethod = expr.getPropertyObjectNames();
        if ((varName.equals("viewScope") || varName.equals("pageFlowScope") || varName.equals("backingBeanScope")) && fieldsOrMethod.size() > 0) {
            varName = fieldsOrMethod.get(0);
            if (fieldsOrMethod.size() > 1) {
                fieldsOrMethod = fieldsOrMethod.subList(1, fieldsOrMethod.size());
            }
        }
        if (!(foundVariables = varQuery.findVariable(new VariableQuery.NameMatcher(varName))).isEmpty() && fieldsOrMethod.size() > 0) {
            Variable var = foundVariables.get(0);
            String methodName = fieldsOrMethod.get(fieldsOrMethod.size() - 1);
            List<String> propFields = this.getPropFields(fieldsOrMethod);
            return this.createMethodReference(valRefFactory.createValueReference(var, propFields), methodName);
        }
        return null;
    }

    private List<String> getPropFields(List<String> fieldsOrMethod) {
        ArrayList<String> allButLast = new ArrayList<String>();
        int copySize = fieldsOrMethod.size() - 1;
        int i = 0;
        while (i < copySize) {
            allButLast.add(fieldsOrMethod.get(i));
            ++i;
        }
        return allButLast;
    }

    private MethodInfo findMethodInfoByName(ValueReference valRef, String methodName) {
        DataType type = valRef.getType(DataType.NullModelContext.getInstance());
        if (type != null) {
            List<MethodInfo> methods = type.getPublicMethods();
            for (MethodInfo methodInfo : methods) {
                if (!methodInfo.getMethodName().equals(methodName)) continue;
                return methodInfo;
            }
        }
        return null;
    }
}

