/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.variables;

import java.util.List;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.MethodInfo;
import oracle.eclipse.tools.application.common.services.variables.ValueReference;
import oracle.eclipse.tools.common.services.util.ObjectUtil;

public class MethodReference {
    private ValueReference _valRef;
    private MethodInfo _methodInfo;

    public MethodReference(ValueReference valRef, MethodInfo methodInfo) {
        this._valRef = valRef;
        this._methodInfo = methodInfo;
    }

    public ValueReference getValueReference() {
        return this._valRef;
    }

    public MethodInfo getMethodInfo() {
        return this._methodInfo;
    }

    public String getMethodName() {
        return this._methodInfo.getMethodName();
    }

    public DataType getMethodReturnType() {
        return this._methodInfo.getReturnedType();
    }

    public List<DataType> getMethodParameterTypes() {
        return this._methodInfo.getParameterTypes();
    }

    public String toString() {
        StringBuffer s = new StringBuffer(this._valRef.toString());
        s.append('.').append(this.getMethodName());
        return s.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MethodReference)) {
            return false;
        }
        MethodReference thatRef = (MethodReference)obj;
        if (this.getValueReference() == null ? thatRef.getValueReference() != null : !this.getValueReference().equals(thatRef.getValueReference())) {
            return false;
        }
        return ObjectUtil.equalObjects((Object)this.getMethodName(), (Object)thatRef.getMethodName());
    }

    public int hashCode() {
        int hash = 17;
        if (this.getMethodName() != null) {
            hash += this.getMethodName().hashCode();
        }
        if (this._methodInfo.getReturnedType() != null) {
            hash += this._methodInfo.getReturnedType().getName().hashCode() * 7;
        }
        if (this._methodInfo.getParameterTypes() != null) {
            for (DataType paramType : this._methodInfo.getParameterTypes()) {
                hash += paramType.getName().hashCode() * 11;
            }
        }
        return hash;
    }

    public boolean matches(MethodReference methodRef) {
        return !this.matchesSignature(methodRef) ? false : methodRef.getMethodName().equals(this.getMethodName());
    }

    public boolean matchesSignature(MethodReference methodRef) {
        return this.returnTypeMatches(methodRef) && this.paramTypesMatch(methodRef);
    }

    private boolean paramTypesMatch(MethodReference methodRef) {
        if (methodRef.getMethodParameterTypes().size() == this.getMethodParameterTypes().size()) {
            int i = 0;
            while (i < methodRef.getMethodParameterTypes().size()) {
                DataType thatDT = methodRef.getMethodParameterTypes().get(i);
                DataType thisDT = this.getMethodParameterTypes().get(i);
                if (!this.typesMatchable(thisDT, thatDT)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private boolean returnTypeMatches(MethodReference methodRef) {
        return this.typesMatchable(this.getMethodReturnType(), methodRef.getMethodReturnType());
    }

    private boolean typesMatchable(DataType thisType, DataType thatType) {
        return thisType.isMatchable(thatType);
    }

    public String getLabel() {
        return this._methodInfo.getLabel();
    }
}

