/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.variables;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.application.common.services.util.UrlUtil;
import oracle.eclipse.tools.application.common.services.variables.Location;
import oracle.eclipse.tools.application.common.services.variables.Locator;
import oracle.eclipse.tools.application.common.services.variables.LocatorFactory;
import oracle.eclipse.tools.common.services.project.Project;

public class Marker {
    private static final String LOCATOR_ATTR = "locator.name";
    private static final String APPLICATION_TYPE_ATTR = "application.type.name";
    private static final String PROJECT_FOLDER_ATTR = "project.folder";
    private static final String WEBAPP_FOLDER_ATTR = "webapp.folder";
    private static final String MARKER_NAME = "marker.name";
    private Project _project;
    private Map mAttributes = new HashMap();
    private Location mLocation;

    public Marker(String locatorName, Project project) {
        this._project = project;
        this.setLocatorName(locatorName);
    }

    public Marker() {
    }

    public Project getProject() {
        return this._project;
    }

    public String getName() {
        Location location;
        String name = (String)this.mAttributes.get(MARKER_NAME);
        if (name == null && (location = this.getLocation()) != null) {
            name = UrlUtil.getUrlFileName(location.getUrl());
        }
        return name;
    }

    public void setName(String name) {
        this.mAttributes.put(MARKER_NAME, name);
    }

    public Set getAttributeNames() {
        return this.mAttributes.keySet();
    }

    public String getAttributeValue(String attributeName) {
        return (String)this.mAttributes.get(attributeName);
    }

    public void setAttributeValue(String attributeName, String attributeValue) {
        this.mAttributes.put(attributeName, attributeValue);
    }

    public String getLocatorName() {
        return this.getAttributeValue(LOCATOR_ATTR);
    }

    public void setLocatorName(String locatorName) {
        this.setAttributeValue(LOCATOR_ATTR, locatorName);
    }

    public String getApplicationType() {
        return this.getAttributeValue(APPLICATION_TYPE_ATTR);
    }

    public void setApplicationType(String appType) {
        this.setAttributeValue(APPLICATION_TYPE_ATTR, appType);
    }

    public void setProjectFolder(File projectFolder) {
        this.setAttributeValue(PROJECT_FOLDER_ATTR, projectFolder.toString());
    }

    public File getProjectFolder() {
        String uri = this.getAttributeValue(PROJECT_FOLDER_ATTR);
        if (uri == null) {
            return null;
        }
        return new File(uri);
    }

    public void setWebAppFolder(File webAppFolder) {
        this.setAttributeValue(WEBAPP_FOLDER_ATTR, webAppFolder.toString());
    }

    public File getWebAppFolder() {
        String uri = this.getAttributeValue(WEBAPP_FOLDER_ATTR);
        if (uri == null) {
            return null;
        }
        return new File(uri);
    }

    public Location getLocation() {
        if (this.mLocation == null) {
            String appType = this.getApplicationType();
            String locatorName = this.getLocatorName();
            if (appType == null || locatorName == null) {
                return null;
            }
            Locator locator = LocatorFactory.getLocatorFactory().getLocator(appType, locatorName);
            if (locator == null) {
                return null;
            }
            this.mLocation = locator.locate(this);
        }
        return this.mLocation;
    }

    protected void setLocation(Location location) {
        this.mLocation = location;
    }

    public void open() {
    }
}

