/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.variables;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.application.common.services.techextservices.IDataTypeIntrospector;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.JDTDataType;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.services.util.ObjectUtil;
import oracle.eclipse.tools.common.services.util.SerializationUtil;
import org.eclipse.jdt.core.IType;
import org.eclipse.jst.jsf.context.IModelContext;

public class MapDataType
extends JDTDataType {
    private static final long serialVersionUID = 1454029523400881167L;
    private final DataType _keyType;
    private final DataType _valueType;
    private Map<String, Object> additionalProps;

    MapDataType(IDataTypeIntrospector introspector, IType type, String typeName, DataType componentType, Project project, boolean isPrimitive, int arrayDimensions, DataType keyType, DataType valueType) {
        this(introspector, type, typeName, componentType, project, isPrimitive, arrayDimensions, keyType, valueType, Collections.EMPTY_MAP);
    }

    MapDataType(IDataTypeIntrospector introspector, IType type, String typeName, DataType componentType, Project project, boolean isPrimitive, int arrayDimensions, DataType keyType, DataType valueType, Map<String, Object> additionalProps) {
        super(introspector, type, typeName, componentType, project, isPrimitive, arrayDimensions);
        this.setMap();
        this._keyType = keyType;
        this._valueType = valueType;
        this.additionalProps = additionalProps.isEmpty() ? Collections.EMPTY_MAP : new HashMap<String, Object>(additionalProps);
    }

    @Override
    public String getDisplayName(boolean abbreviated) {
        String displayName;
        String string = displayName = abbreviated ? ObjectUtil.getClassName((String)this.getName()) : this.getName();
        if (!this.isRawType()) {
            displayName = String.valueOf(displayName) + '<' + this.getKeyType().getDisplayName(abbreviated) + ", " + this.getValueType().getDisplayName(abbreviated) + '>';
        }
        displayName = displayName.replace('$', '.');
        return displayName;
    }

    @Override
    public List<DataType.Field> getFields(IModelContext modelContext) {
        ArrayList<DataType.Field> fields = new ArrayList<DataType.Field>(super.getFields(modelContext));
        for (Map.Entry<String, Object> entry : this.additionalProps.entrySet()) {
            fields.add(new JDTDataType.JavaField(entry.getKey(), DataType.getUnspecifiedType(), null, null, null));
        }
        return Collections.unmodifiableList(fields);
    }

    public DataType getKeyType() {
        return this._keyType;
    }

    public DataType getValueType() {
        return this._valueType;
    }

    public boolean isRawType() {
        return this._keyType == null && this._valueType == null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this._keyType);
        out.writeObject(this._valueType);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, IllegalArgumentException, IllegalAccessException {
        SerializationUtil su = SerializationUtil.forInput((ObjectInputStream)in);
        su.readFinalFieldFromStream((Object)this, "_keyType", DataType.class);
        su.readFinalFieldFromStream((Object)this, "_valueType", DataType.class);
    }

    private Object readResolve() {
        JDTDataType readResolvedType = null;
        if (this.isMap()) {
            readResolvedType = JDTDataType.instanceForMap(this.getIntrospector(), this.getType(), this._keyType, this._valueType, this.getArrayDimensions());
        }
        return readResolvedType == null ? this : readResolvedType;
    }
}

