/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.variables;

import java.beans.Introspector;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.application.common.services.appservices.IDatatypeProvider;
import oracle.eclipse.tools.application.common.services.techextservices.IDataTypeIntrospector;
import oracle.eclipse.tools.application.common.services.variables.AnnotationInfo;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.IJavaElementMatcher;
import oracle.eclipse.tools.application.common.services.variables.MapDataType;
import oracle.eclipse.tools.application.common.services.variables.MethodInfo;
import oracle.eclipse.tools.application.common.services.variables.PropertyDescriptor;
import oracle.eclipse.tools.application.common.services.variables.WildcardDataType;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.services.util.SerializationUtil;
import oracle.eclipse.tools.xml.model.Activator;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.j2ee.internal.common.operations.JavaModelUtil;
import org.eclipse.jst.jsf.context.IModelContext;

public class JDTDataType
extends DataType {
    private static final long serialVersionUID = 1L;
    private static final String ENUM_BASE = "Ljava.lang.Enum;";
    private static final String GET_PREFIX = "get";
    private static final String SET_PREFIX = "set";
    private static final String IS_PREFIX = "is";
    private static final String STRING_BYTES_FIELD = "bytes";
    private static final String STRING_EMPTY_FIELD = "empty";
    private static IJavaElementMatcher<IMethod> _defaultConstructorMatcher = new IJavaElementMatcher<IMethod>(){

        @Override
        public boolean matches(IMethod method) throws JavaModelException {
            int flags = method.getFlags();
            return !method.getDeclaringType().isInterface() && Flags.isPublic((int)flags) && !Flags.isStatic((int)flags) && method.isConstructor();
        }

        @Override
        public void avoidFutureDuplicates(IMethod element) throws JavaModelException {
        }
    };
    private static final Map<String, String> PRIMITIVE_TO_WRAPPER_MAP = new HashMap<String, String>(8, 1.0f);
    private static final String DATE_TYPE_NAME;
    private static final Map<String, String> WRAPPER_TO_PRIMITIVE_MAP;
    private static final Set<String> ENUMERABLE_TYPES;
    private static final String OBJECT_TYPE_NAME = "java.lang.Object";
    private final IType _type;
    private final boolean _isPrimitive;
    private final int _arrayDimensions;
    private final transient IDataTypeIntrospector _introspector;
    private final DataType _componentType;
    private final List<DataType.Field> _injectedFields = new ArrayList<DataType.Field>(3);
    private final List<MethodInfo> _publicMethods = new ArrayList<MethodInfo>();
    private final List<MethodInfo> _constructors = new ArrayList<MethodInfo>(3);
    private final List<DataType.Field> _fields = new ArrayList<DataType.Field>();
    private final HashSet<String> _superClassSignatures = new HashSet();
    private final List<IType> _superTypes = new LinkedList<IType>();
    private final Set<String> _interfaceSignatures = new HashSet<String>();
    private List<AnnotationInfo> _annotations;

    static {
        PRIMITIVE_TO_WRAPPER_MAP.put(Integer.TYPE.getName(), Integer.class.getName());
        PRIMITIVE_TO_WRAPPER_MAP.put(Boolean.TYPE.getName(), Boolean.class.getName());
        PRIMITIVE_TO_WRAPPER_MAP.put(Character.TYPE.getName(), Character.class.getName());
        PRIMITIVE_TO_WRAPPER_MAP.put(Float.TYPE.getName(), Float.class.getName());
        PRIMITIVE_TO_WRAPPER_MAP.put(Double.TYPE.getName(), Double.class.getName());
        PRIMITIVE_TO_WRAPPER_MAP.put(Byte.TYPE.getName(), Byte.class.getName());
        PRIMITIVE_TO_WRAPPER_MAP.put(Short.TYPE.getName(), Short.class.getName());
        PRIMITIVE_TO_WRAPPER_MAP.put(Long.TYPE.getName(), Long.class.getName());
        DATE_TYPE_NAME = Date.class.getName();
        WRAPPER_TO_PRIMITIVE_MAP = new HashMap<String, String>(9, 1.0f);
        WRAPPER_TO_PRIMITIVE_MAP.put(Integer.class.getName(), Integer.TYPE.getName());
        WRAPPER_TO_PRIMITIVE_MAP.put(Boolean.class.getName(), Boolean.TYPE.getName());
        WRAPPER_TO_PRIMITIVE_MAP.put(Character.class.getName(), Character.TYPE.getName());
        WRAPPER_TO_PRIMITIVE_MAP.put(Float.class.getName(), Float.TYPE.getName());
        WRAPPER_TO_PRIMITIVE_MAP.put(Double.class.getName(), Double.TYPE.getName());
        WRAPPER_TO_PRIMITIVE_MAP.put(Byte.class.getName(), Byte.TYPE.getName());
        WRAPPER_TO_PRIMITIVE_MAP.put(Short.class.getName(), Short.TYPE.getName());
        WRAPPER_TO_PRIMITIVE_MAP.put(Long.class.getName(), Long.TYPE.getName());
        ENUMERABLE_TYPES = new HashSet<String>(4, 1.0f);
        ENUMERABLE_TYPES.add(Collection.class.getName());
        ENUMERABLE_TYPES.add(Enumeration.class.getName());
        ENUMERABLE_TYPES.add(Iterator.class.getName());
        ENUMERABLE_TYPES.add(Map.class.getName());
    }

    public static JDTDataType instanceFor(IDataTypeIntrospector introspector, IType type, DataType componentType, int arrayDimension) {
        if (type == null) {
            throw new NullPointerException("Type can not be null.");
        }
        IProject project = type.getJavaProject().getProject();
        return new JDTDataType(introspector, type, JDTDataType.getName(type.getFullyQualifiedName(), false), componentType, (Project)project.getAdapter(Project.class), false, arrayDimension);
    }

    public static JDTDataType instanceForWildcard(IDataTypeIntrospector introspector, IType type, String originalWildcard, DataType componentType, int arrayDimension) {
        if (type == null) {
            throw new NullPointerException("Type cannot be null.");
        }
        IProject iProject = type.getJavaProject().getProject();
        Project project = (Project)iProject.getAdapter(Project.class);
        return new WildcardDataType(introspector, type, JDTDataType.getName(type.getFullyQualifiedName(), false), originalWildcard, componentType, project, arrayDimension);
    }

    public static JDTDataType instanceForMap(IDataTypeIntrospector introspector, IType type, DataType keyType, DataType valueType, int arrayDimension) {
        return JDTDataType.instanceForMap(introspector, type, keyType, valueType, arrayDimension, Collections.EMPTY_MAP);
    }

    public static JDTDataType instanceForMap(IDataTypeIntrospector introspector, IType type, DataType keyType, DataType valueType, int arrayDimension, Map additionalProps) {
        if (type == null) {
            throw new NullPointerException("Type cannot be null.");
        }
        IProject iProject = type.getJavaProject().getProject();
        Project project = (Project)iProject.getAdapter(Project.class);
        return new MapDataType(introspector, type, JDTDataType.getName(type.getFullyQualifiedName(), false), introspector.introspect("java.util.Map$Entry", null), project, false, arrayDimension, keyType, valueType, additionalProps);
    }

    public static JDTDataType instanceFor(IDataTypeIntrospector introspector, String typeName, DataType componentType, IProject project, int arrayDimension) {
        return new JDTDataType(introspector, null, typeName, componentType, (Project)project.getAdapter(Project.class), false, arrayDimension);
    }

    public static JDTDataType instanceForPrimitive(IDataTypeIntrospector introspector, String primitiveType, int arrayDimension, IJavaProject jProject) throws JavaModelException {
        if (primitiveType == null) {
            throw new NullPointerException("primitiveType can not be null");
        }
        if (jProject == null) {
            throw new NullPointerException("Project can not be null.");
        }
        String wrapperTypeName = JDTDataType.getPrimitiveWrapper(primitiveType);
        IProject project = jProject.getProject();
        IType wrapperType = jProject.findType(wrapperTypeName);
        if (wrapperType == null) {
            return null;
        }
        return new JDTDataType(introspector, wrapperType, JDTDataType.getName(wrapperType.getFullyQualifiedName(), true), null, (Project)project.getAdapter(Project.class), true, arrayDimension);
    }

    private static String getPrimitiveWrapper(String primitiveName) {
        return PRIMITIVE_TO_WRAPPER_MAP.get(primitiveName);
    }

    private static String getPrimitiveType(String wrapperName) {
        return WRAPPER_TO_PRIMITIVE_MAP.get(wrapperName);
    }

    public static boolean isPrimitive(String typeName) {
        return PRIMITIVE_TO_WRAPPER_MAP.get(typeName) != null;
    }

    protected JDTDataType(IDataTypeIntrospector introspector, IType type, String typeName, DataType componentType, Project project, boolean isPrimitive, int arrayDimensions) {
        super(null, typeName, project);
        this._type = type;
        this._isPrimitive = isPrimitive;
        this._arrayDimensions = arrayDimensions;
        this._introspector = introspector;
        this._componentType = componentType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLoaded(boolean loaded) {
        super.setLoaded(loaded);
        if (!loaded && this._type != null) {
            IType iType = this._type;
            synchronized (iType) {
                this._publicMethods.clear();
                this._constructors.clear();
                this._fields.clear();
                this._superClassSignatures.clear();
                this._superTypes.clear();
                this._interfaceSignatures.clear();
                this._annotations = null;
            }
        }
    }

    private static String getName(String qualifiedName, boolean isPrimitive) {
        if (Void.class.getName().equals(qualifiedName)) {
            return Void.TYPE.getName();
        }
        if (isPrimitive) {
            return WRAPPER_TO_PRIMITIVE_MAP.get(qualifiedName);
        }
        return qualifiedName;
    }

    @Override
    public String getDisplayName(boolean abbreviated) {
        String displayName = super.getDisplayName(abbreviated);
        if (this._arrayDimensions > 1) {
            StringBuilder builder = new StringBuilder(displayName);
            int i = 1;
            while (i < this._arrayDimensions) {
                builder.append('[');
                builder.append(']');
                ++i;
            }
            return builder.toString();
        }
        return displayName;
    }

    public IDataTypeIntrospector getIntrospector() {
        return this._introspector;
    }

    public IType getType() {
        return this._type;
    }

    int getArrayDimensions() {
        return this._arrayDimensions;
    }

    DataType getRawComponentType() {
        return this._componentType;
    }

    public List<MethodInfo> getPublicConstructors() {
        return this.getMethods(this._constructors, _defaultConstructorMatcher, false, true);
    }

    @Override
    public List<MethodInfo> getPublicMethods() {
        return this.getPublicMethods(false);
    }

    public List<MethodInfo> getPublicMethods(boolean filterObjectClassMethods) {
        return this.getMethods(this._publicMethods, new PublicMethodMatcher(), true, filterObjectClassMethods);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AnnotationInfo> getAnnotations() {
        if (this._annotations == null && this._type != null) {
            IType iType = this._type;
            synchronized (iType) {
                try {
                    this._annotations = new ArrayList<AnnotationInfo>();
                    IAnnotation[] iAnnotationArray = this._type.getAnnotations();
                    int n = iAnnotationArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IAnnotation anno = iAnnotationArray[n2];
                        this._annotations.add(new AnnotationInfo(anno));
                        ++n2;
                    }
                }
                catch (JavaModelException e) {
                    Activator.log((Throwable)e);
                }
            }
        }
        if (this._annotations == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this._annotations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MethodInfo> getMethods(List<MethodInfo> methods, IJavaElementMatcher<IMethod> matcher, boolean includeInherited, boolean filterObjectClassMethods) {
        if (this._type != null) {
            IType iType = this._type;
            synchronized (iType) {
                if (methods.isEmpty()) {
                    try {
                        ArrayList<IMethod> allMethods = new ArrayList<IMethod>(20);
                        this.getAllMethods(allMethods, this._type, filterObjectClassMethods, matcher, includeInherited);
                        for (IMethod method : allMethods) {
                            IType declaringType = method.getDeclaringType();
                            if (!declaringType.isInterface() && !Flags.isPublic((int)method.getFlags())) continue;
                            String returnTypeSignature = method.getReturnType();
                            String returnType = JDTDataType.resolveType(declaringType, returnTypeSignature);
                            if (returnType == null) {
                                returnType = Signature.toString((String)returnTypeSignature);
                            }
                            String[] paramSigs = method.getParameterTypes();
                            String[] paramNames = method.getParameterNames();
                            String[] paramTypes = new String[paramSigs.length];
                            int i = 0;
                            while (i < paramSigs.length) {
                                String signature = paramSigs[i];
                                String paramType = JDTDataType.resolveType(declaringType, signature);
                                if (paramType == null) {
                                    paramType = Signature.toString((String)signature);
                                }
                                paramTypes[i] = paramType;
                                ++i;
                            }
                            ArrayList<AnnotationInfo> annotations = new ArrayList<AnnotationInfo>();
                            IAnnotation[] annos = method.getAnnotations();
                            int i2 = 0;
                            while (i2 < annos.length) {
                                annotations.add(new AnnotationInfo(annos[i2]));
                                ++i2;
                            }
                            try {
                                methods.add(new MethodInfo(this._introspector, this, method.getElementName(), returnType, paramTypes, paramNames, annotations, new Integer(method.getFlags())));
                            }
                            catch (Exception exception) {}
                        }
                    }
                    catch (JavaModelException javaModelException) {}
                }
            }
        }
        return methods == null ? Collections.emptyList() : Collections.unmodifiableList(methods);
    }

    @Override
    public boolean isUnknown() {
        return this._type == null;
    }

    @Override
    public boolean isPrimitiveType() {
        return this._isPrimitive;
    }

    @Override
    public boolean isDate() {
        if (this._type == null) {
            return false;
        }
        if (DATE_TYPE_NAME.equals(this._type.getFullyQualifiedName())) {
            return true;
        }
        return this.getSuperClassSignatures().contains(Signature.createTypeSignature((String)DATE_TYPE_NAME, (boolean)true));
    }

    @Override
    public boolean isUpdatable() {
        ICompilationUnit cu;
        if (this._type == null) {
            return false;
        }
        return !this._isPrimitive && (cu = this._type.getCompilationUnit()) != null && !cu.isReadOnly() && this._type.getResource().isAccessible() && !this._type.getResource().getResourceAttributes().isReadOnly();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isSubClass(String className) {
        if (this._type == null) {
            return false;
        }
        if (className == null) {
            return false;
        }
        if (this.isPrimitiveType()) return false;
        if (JDTDataType.isPrimitive(className)) {
            return false;
        }
        if (this.getName().equals(className)) {
            return true;
        }
        try {
            IType superType = JDTDataType.getSuperType(this._type);
            while (true) {
                if (superType == null) {
                    return false;
                }
                String superClassName = superType.getFullyQualifiedName();
                if (superClassName == null) return false;
                if (superClassName.equals(className)) {
                    return true;
                }
                superType = JDTDataType.getSuperType(superType);
            }
        }
        catch (JavaModelException javaModelException) {}
        return false;
    }

    @Override
    public boolean isAssignableFrom(String superClassName) {
        if (this._type == null) {
            return false;
        }
        if (superClassName == null) {
            return false;
        }
        assert (!this.isPrimitiveType() && !JDTDataType.isPrimitive(superClassName));
        return this.isAssignableFromAny(Collections.singleton(superClassName));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isAssignableFromAny(Set<String> superClasses) {
        if (this._type == null) {
            return false;
        }
        if (superClasses.isEmpty()) {
            return false;
        }
        if (superClasses.contains(this.getName())) {
            return true;
        }
        try {
            String superClass;
            IType superType;
            ITypeHierarchy th = this._type.newSupertypeHierarchy(null);
            Iterator<String> iterator = superClasses.iterator();
            do {
                if (!iterator.hasNext()) {
                    return false;
                }
                superClass = iterator.next();
            } while ((superType = this._type.getJavaProject().findType(superClass)) == null || !th.contains(superType));
            return true;
        }
        catch (JavaModelException javaModelException) {}
        return false;
    }

    @Override
    public boolean isMatchable(DataType otherType) {
        if (this._type == null) {
            return false;
        }
        if (this.isArray() && !otherType.isArray() || !this.isArray() && otherType.isArray()) {
            return false;
        }
        if (this.isPrimitiveType() || otherType.isPrimitiveType()) {
            if (otherType.isBoolean() && this.isBoolean()) {
                return true;
            }
            if (otherType.isNumeric() && this.isNumeric()) {
                return true;
            }
            if (otherType.getDisplayName(false).equals(Character.TYPE.getName()) && this.getDisplayName(false).equals(Character.TYPE.getName())) {
                return true;
            }
        } else {
            if (otherType.isSubClass(this.getName())) {
                return true;
            }
            if (otherType.isAssignableFrom(this.getName())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isArray() {
        if (this._type == null) {
            return false;
        }
        return this._arrayDimensions > 0;
    }

    @Override
    public boolean isEnumerable() {
        if (this._type == null) {
            return false;
        }
        return this.isArray() || this.isAssignableFromAny(ENUMERABLE_TYPES);
    }

    @Override
    public boolean isEnum() {
        if (this._type == null) {
            return false;
        }
        if (ENUM_BASE.equals(Signature.createTypeSignature((String)this._type.getFullyQualifiedName(), (boolean)true))) {
            return true;
        }
        try {
            return this._type.isEnum();
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DataType.Field> getFields(IModelContext modelContext) {
        if (this._type == null || this._isPrimitive) {
            return Collections.emptyList();
        }
        IType iType = this._type;
        synchronized (iType) {
            if (this._fields.isEmpty()) {
                try {
                    ArrayList<IMethod> methods = new ArrayList<IMethod>(20);
                    this.getAllMethods(methods, this._type, true, new PublicMethodMatcher(), true);
                    HashMap<String, PropertyDescriptor> propertyMap = new HashMap<String, PropertyDescriptor>();
                    for (IMethod method : methods) {
                        boolean startsWithSet;
                        String methodName = method.getElementName();
                        String returnType = method.getReturnType();
                        boolean startsWithIs = methodName.startsWith(IS_PREFIX) && "Z".equals(returnType) && method.getNumberOfParameters() == 0 && methodName.length() > IS_PREFIX.length();
                        boolean startsWithGet = methodName.startsWith(GET_PREFIX) && method.getNumberOfParameters() == 0 && !"V".equals(returnType) && methodName.length() > GET_PREFIX.length();
                        boolean bl = startsWithSet = methodName.startsWith(SET_PREFIX) && method.getNumberOfParameters() == 1 && "V".equals(returnType) && methodName.length() > SET_PREFIX.length();
                        if (!startsWithGet && !startsWithSet && !startsWithIs) continue;
                        String propertyName = Introspector.decapitalize(methodName.substring(startsWithIs ? 2 : 3));
                        PropertyDescriptor propDesc = (PropertyDescriptor)propertyMap.get(propertyName);
                        if (propDesc == null) {
                            propDesc = new PropertyDescriptor(this, propertyName);
                            propertyMap.put(propertyName, propDesc);
                        }
                        if (startsWithGet) {
                            propDesc.setReadMethodName(methodName);
                            propDesc.setReturnType(JDTDataType.resolveType(method.getDeclaringType(), returnType));
                            continue;
                        }
                        if (startsWithIs) {
                            if (propDesc.getReadMethodName() != null) continue;
                            propDesc.setReadMethodName(methodName);
                            propDesc.setReturnType(JDTDataType.resolveType(method.getDeclaringType(), returnType));
                            continue;
                        }
                        propDesc.setWriteMethodName(methodName);
                        if (propDesc.getReadMethodName() != null) continue;
                        String paramType = method.getParameterTypes()[0];
                        propDesc.setReturnType(JDTDataType.resolveType(method.getDeclaringType(), paramType));
                    }
                    for (PropertyDescriptor propDesc : propertyMap.values()) {
                        if (this.filterOut(propDesc)) continue;
                        IField fld = this._type.getField(propDesc.getName());
                        this._fields.add(new JavaField(propDesc.getName(), propDesc.getPropertyType(), propDesc.getReadMethodName(), propDesc.getWriteMethodName(), fld));
                    }
                }
                catch (JavaModelException javaModelException) {}
            }
        }
        ArrayList<DataType.Field> fields = new ArrayList<DataType.Field>(this._fields);
        fields.addAll(super.getFields(modelContext));
        List<DataType.Field> list = this._injectedFields;
        synchronized (list) {
            fields.addAll(this._injectedFields);
        }
        return Collections.unmodifiableList(fields);
    }

    protected boolean filterOut(PropertyDescriptor propDesc) {
        return propDesc.getParentType().isString() && (STRING_BYTES_FIELD.equals(propDesc.getName()) || STRING_EMPTY_FIELD.equals(propDesc.getName()));
    }

    @Override
    public int getNumFields(IModelContext modelContext) {
        return this.getFields(modelContext).size();
    }

    @Override
    public DataType.Field getField(String fieldName, IModelContext modelContext) {
        for (DataType.Field field : this.getFields(modelContext)) {
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        return null;
    }

    @Override
    public DataType getComponentType() {
        if (this.isArray()) {
            return new JDTDataType(this._introspector, this._type, this.getName(), this._componentType, this.getProject(), this._isPrimitive, 0);
        }
        if (this.isEnumerable()) {
            return this._componentType == null ? DataType.getUnspecifiedType() : this._componentType;
        }
        return null;
    }

    @Override
    public boolean isLoaded() {
        return true;
    }

    @Override
    protected void addSuperClassSignatures(Set<String> superClasses) {
        try {
            superClasses.addAll(this.getSuperClassTypeSignatures());
        }
        catch (JavaModelException javaModelException) {}
    }

    @Override
    protected void addSuperInterfaceSignatures(Set<String> interfaces) {
        try {
            interfaces.addAll(this.getInterfacesTypeSignatures());
        }
        catch (JavaModelException javaModelException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInjectedFields(DataType.Field field) {
        List<DataType.Field> list = this._injectedFields;
        synchronized (list) {
            if (field != null) {
                this._injectedFields.add(field);
            }
        }
    }

    private static boolean isResolved(String typeSig) {
        if (typeSig.charAt(0) == '[' || typeSig.charAt(0) == '+') {
            if (typeSig.length() > 1) {
                return typeSig.charAt(1) != 'Q';
            }
        } else {
            return typeSig.charAt(0) != 'Q';
        }
        return true;
    }

    private static String resolveType(IType declaringType, String typeSignature) throws JavaModelException {
        if (JDTDataType.isResolved(typeSignature)) {
            return Signature.toString((String)typeSignature);
        }
        String resolvedType = JavaModelUtil.getResolvedTypeName((String)typeSignature, (IType)declaringType);
        if (resolvedType != null) {
            String[] parameterTypeSigs;
            StringBuilder sb = new StringBuilder(resolvedType);
            if (typeSignature.indexOf(60) != -1 && (parameterTypeSigs = Signature.getTypeArguments((String)typeSignature)) != null && parameterTypeSigs.length > 0) {
                ArrayList<String> resolvedParamSigs = new ArrayList<String>(parameterTypeSigs.length);
                String[] stringArray = parameterTypeSigs;
                int n = parameterTypeSigs.length;
                int n2 = 0;
                while (n2 < n) {
                    String parameterTypeSig = stringArray[n2];
                    String resolvedParamSig = JDTDataType.resolveType(declaringType, parameterTypeSig);
                    resolvedParamSigs.add(resolvedParamSig);
                    ++n2;
                }
                if (!resolvedParamSigs.contains(null)) {
                    sb.append('<');
                    int i = 0;
                    while (i < resolvedParamSigs.size()) {
                        if (i != 0) {
                            sb.append(',');
                        }
                        sb.append((String)resolvedParamSigs.get(i));
                        ++i;
                    }
                    sb.append('>');
                }
            }
            int arrayCount = Signature.getArrayCount((String)typeSignature);
            int i = 0;
            while (i < arrayCount) {
                sb.append("[]");
                ++i;
            }
            return sb.toString();
        }
        return null;
    }

    private static String resolveTypeSignature(IType declaringType, String typeSignature) throws JavaModelException {
        String resolvedTypeName = JDTDataType.resolveType(declaringType, typeSignature);
        return resolvedTypeName == null ? null : Signature.createTypeSignature((String)resolvedTypeName, (boolean)true);
    }

    private static IType getSuperType(IType subType) throws JavaModelException {
        String superClassSignature = subType.getSuperclassTypeSignature();
        if (superClassSignature != null) {
            String resolvedType = JDTDataType.resolveType(subType, superClassSignature);
            if (resolvedType != null) {
                return subType.getJavaProject().findType(resolvedType);
            }
            superClassSignature = Signature.getTypeErasure((String)superClassSignature);
            return subType.getJavaProject().findType(Signature.getSignatureQualifier((String)superClassSignature), Signature.getSignatureSimpleName((String)superClassSignature));
        }
        return null;
    }

    private List<IMethod> getAllMethods(List<IMethod> methods, IType jType, boolean filterObjectClassMethods, IJavaElementMatcher<IMethod> matcher, boolean includeInherited) throws JavaModelException {
        IType oType;
        if (filterObjectClassMethods && OBJECT_TYPE_NAME.equals(jType.getFullyQualifiedName())) {
            return methods;
        }
        boolean processedObject = false;
        if (jType != null && (includeInherited || jType == this._type)) {
            IType superType;
            if (OBJECT_TYPE_NAME.equals(jType.getFullyQualifiedName())) {
                processedObject = true;
                if (!filterObjectClassMethods) {
                    methods.addAll(this.filterMethods(jType.getMethods(), matcher));
                }
            } else {
                methods.addAll(this.filterMethods(jType.getMethods(), matcher));
            }
            if (includeInherited && (superType = JDTDataType.getSuperType(jType)) != null) {
                this.getAllMethods(methods, superType, filterObjectClassMethods, matcher, includeInherited);
            }
        }
        if (includeInherited && !filterObjectClassMethods && !processedObject && jType != null && (oType = jType.getJavaProject().findType(OBJECT_TYPE_NAME)) != null) {
            methods.addAll(this.filterMethods(oType.getMethods(), matcher));
        }
        return methods;
    }

    private List<IMethod> filterMethods(IMethod[] allMethods, IJavaElementMatcher<IMethod> matcher) throws JavaModelException {
        if (allMethods == null) {
            return Collections.emptyList();
        }
        ArrayList<IMethod> methods = new ArrayList<IMethod>(allMethods.length);
        IMethod[] iMethodArray = allMethods;
        int n = allMethods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            if (matcher.matches(method)) {
                methods.add(method);
                matcher.avoidFutureDuplicates(method);
            }
            ++n2;
        }
        return methods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<IType> getSuperTypes() throws JavaModelException {
        if (this._type != null) {
            IType iType = this._type;
            synchronized (iType) {
                if (this._superTypes.isEmpty()) {
                    IType superType = JDTDataType.getSuperType(this._type);
                    while (superType != null) {
                        this._superTypes.add(superType);
                        superType = JDTDataType.getSuperType(superType);
                    }
                }
            }
        }
        return Collections.unmodifiableList(this._superTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Set<String> getSuperClassTypeSignatures() throws JavaModelException {
        if (this._type != null && !this._isPrimitive) {
            IType iType = this._type;
            synchronized (iType) {
                if (this._superClassSignatures.isEmpty()) {
                    String superClassTypeSignature = this._type.getSuperclassTypeSignature();
                    if (superClassTypeSignature != null) {
                        this._superClassSignatures.add(JDTDataType.resolveTypeSignature(this._type, superClassTypeSignature));
                    }
                    List<IType> types = this.getSuperTypes();
                    for (IType superType : types) {
                        superClassTypeSignature = superType.getSuperclassTypeSignature();
                        if (superClassTypeSignature == null) continue;
                        this._superClassSignatures.add(JDTDataType.resolveTypeSignature(superType, superClassTypeSignature));
                    }
                }
            }
        }
        return Collections.unmodifiableSet(this._superClassSignatures);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getInterfacesTypeSignatures() throws JavaModelException {
        if (this._type != null && !this._isPrimitive) {
            IType iType = this._type;
            synchronized (iType) {
                if (this._interfaceSignatures.isEmpty()) {
                    String[] stringArray = this._type.getSuperInterfaceTypeSignatures();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String interfaceTypeSignature = stringArray[n2];
                        this._interfaceSignatures.add(JDTDataType.resolveTypeSignature(this._type, interfaceTypeSignature));
                        ++n2;
                    }
                    List<IType> types = this.getSuperTypes();
                    for (IType superType : types) {
                        String[] stringArray2 = superType.getSuperInterfaceTypeSignatures();
                        int n3 = stringArray2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String interfaceTypeSignature = stringArray2[n4];
                            this._interfaceSignatures.add(JDTDataType.resolveTypeSignature(superType, interfaceTypeSignature));
                            ++n4;
                        }
                        IType iType2 = JDTDataType.getSuperType(superType);
                    }
                }
            }
        }
        return Collections.unmodifiableSet(this._interfaceSignatures);
    }

    private Object readResolve() {
        JDTDataType readResolvedType = null;
        if (this._type != null) {
            if (!this._isPrimitive) {
                readResolvedType = JDTDataType.instanceFor(this._introspector, this._type, this._componentType, this._arrayDimensions);
            } else {
                String wrapperTypeName = this._type.getFullyQualifiedName();
                String primitiveType = JDTDataType.getPrimitiveType(wrapperTypeName);
                try {
                    readResolvedType = JDTDataType.instanceForPrimitive(this._introspector, primitiveType, this._arrayDimensions, this._type.getJavaProject());
                }
                catch (JavaModelException javaModelException) {}
            }
        }
        return readResolvedType == null ? this : readResolvedType;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeBoolean(this._isPrimitive);
        out.writeInt(this._arrayDimensions);
        SerializationUtil su = SerializationUtil.forOutput((ObjectOutputStream)out);
        su.writeResource(this._type != null ? this._type.getJavaProject().getProject() : null);
        out.writeObject(this._type != null ? this._type.getFullyQualifiedName() : this.getName());
        out.writeObject(this._componentType);
        out.writeObject(this._injectedFields);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, IllegalArgumentException, IllegalAccessException {
        SerializationUtil su = SerializationUtil.forInput((ObjectInputStream)in);
        su.readFinalFieldFromStream((Object)this, "_isPrimitive", Boolean.TYPE);
        su.readFinalFieldFromStream((Object)this, "_arrayDimensions", Integer.TYPE);
        IProject project = su.readProject();
        Object typeNameObj = in.readObject();
        if (typeNameObj instanceof String && project != null) {
            IType jType;
            String typeName = (String)typeNameObj;
            IJavaProject jProj = JavaCore.create((IProject)project);
            try {
                jType = jProj.findType(typeName);
            }
            catch (JavaModelException e) {
                throw new IllegalStateException("Current data in stream is not of correct type.", e);
            }
            su.setFinalField((Object)this, "_type", IType.class, (Object)jType);
        }
        su.readFinalFieldFromStream((Object)this, "_componentType", DataType.class);
        su.readFinalFieldFromStream((Object)this, "_injectedFields", List.class);
        Project prj = this.getProject();
        IDatatypeProvider dtp = (IDatatypeProvider)prj.getAppService(IDatatypeProvider.class);
        if (dtp != null) {
            su.setFinalField((Object)this, "_introspector", IDataTypeIntrospector.class, (Object)dtp.getIntrospector());
        }
    }

    public boolean isInterface() {
        try {
            return this._type.isInterface();
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    public boolean isPublic() {
        try {
            return Modifier.isPublic(this._type.getFlags());
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    public static class JavaField
    extends DataType.Field {
        private static final long serialVersionUID = 1L;
        private final String mReadMethodName;
        private final String mWriteMethodName;
        private List<AnnotationInfo> mAnnos;

        public JavaField(String name, DataType type, String readMethodName, String writeMethodName, IField fld) {
            super(name, type);
            this.mReadMethodName = readMethodName;
            this.mWriteMethodName = writeMethodName;
            this.initAnnotations(fld);
        }

        private void initAnnotations(IField fld) {
            this.mAnnos = new ArrayList<AnnotationInfo>();
            if (fld != null && fld.exists()) {
                try {
                    IAnnotation[] iAnnotationArray = fld.getAnnotations();
                    int n = iAnnotationArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IAnnotation anno = iAnnotationArray[n2];
                        this.mAnnos.add(new AnnotationInfo(anno));
                        ++n2;
                    }
                }
                catch (JavaModelException javaModelException) {}
            }
        }

        public String getReadMethodName() {
            return this.mReadMethodName;
        }

        public String getWriteMethodName() {
            return this.mWriteMethodName;
        }

        public boolean isReadable() {
            return this.mReadMethodName != null;
        }

        public boolean isWritable() {
            return this.mWriteMethodName != null;
        }

        /*
         * Enabled aggressive block sorting
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public List<AnnotationInfo> getAnnotations() {
            if (this.mAnnos != null) return Collections.unmodifiableList(this.mAnnos);
            DataType dataType = this.getType();
            // MONITORENTER : dataType
            // MONITOREXIT : dataType
            return Collections.unmodifiableList(this.mAnnos);
        }

        @Override
        public boolean equals(Object other) {
            if (other instanceof JavaField && super.equals(other)) {
                JavaField otherField = (JavaField)other;
                String readMethodName = this.getReadMethodName();
                String otherReadMethodName = otherField.getReadMethodName();
                String writeMethodName = this.getWriteMethodName();
                String otherWriteMethodName = otherField.getWriteMethodName();
                return (readMethodName == null ? otherReadMethodName == null : readMethodName.equals(otherReadMethodName)) && (writeMethodName == null ? otherWriteMethodName == null : writeMethodName.equals(otherWriteMethodName));
            }
            return false;
        }

        @Override
        public int hashCode() {
            String readMethodName = this.getReadMethodName();
            String writeMethodName = this.getWriteMethodName();
            int result = super.hashCode();
            result = 37 * result + (readMethodName == null ? 0 : readMethodName.hashCode());
            result = 37 * result + (writeMethodName == null ? 0 : writeMethodName.hashCode());
            return result;
        }
    }

    public static class MapEntryJavaField
    extends JavaField {
        private String optionalValue;
        private static final long serialVersionUID = 1L;

        public MapEntryJavaField(String name, String optionalValue) {
            super(name, DataType.getUnspecifiedType(), null, null, null);
            this.optionalValue = optionalValue;
        }

        public String getOptionalValue() {
            return this.optionalValue;
        }
    }

    private static final class PublicMethodMatcher
    implements IJavaElementMatcher<IMethod> {
        private Map<String, Set<String>> alreadySeenMethod = new HashMap<String, Set<String>>();

        private PublicMethodMatcher() {
        }

        @Override
        public boolean matches(IMethod method) throws JavaModelException {
            Set<String> sigs;
            int flags = method.getFlags();
            return (method.getDeclaringType().isInterface() || Flags.isPublic((int)flags) && !Flags.isStatic((int)flags) && !method.isConstructor()) && ((sigs = this.alreadySeenMethod.get(method.getElementName())) == null || !sigs.contains(method.getSignature()));
        }

        @Override
        public void avoidFutureDuplicates(IMethod element) throws JavaModelException {
            String elementName = element.getElementName();
            Set<String> sigs = this.alreadySeenMethod.get(elementName);
            if (sigs == null) {
                sigs = new HashSet<String>(4);
                this.alreadySeenMethod.put(elementName, sigs);
            }
            sigs.add(element.getSignature());
        }
    }
}

