/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.variables;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.application.common.services.variables.DocumentVariableQuery;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.application.common.services.variables.VariableQuery;
import oracle.eclipse.tools.application.common.services.variables.VariablesController;
import oracle.eclipse.tools.application.common.services.variables.VariablesIterator;
import oracle.eclipse.tools.common.services.document.IDocument;

public class CachingDocumentVariableQuery
extends DocumentVariableQuery {
    private List<Variable> _variables;
    private Map<String, List<Variable>> _nameIndex;

    public CachingDocumentVariableQuery(IDocument document, int offset) {
        super(document, offset);
    }

    @Override
    public List<Variable> findVariable(VariableQuery.QueryMatcher matcher) {
        if (this._variables == null) {
            this.refreshVariables();
        }
        ArrayList<Variable> foundVars = new ArrayList<Variable>();
        if (matcher instanceof VariableQuery.NameOptimizedQueryMatcher) {
            return ((VariableQuery.NameOptimizedQueryMatcher)matcher).getMatches(this._nameIndex);
        }
        for (Variable var : this._variables) {
            if (!matcher.matches(var)) continue;
            foundVars.add(var);
        }
        return foundVars;
    }

    public void reset() {
        this._variables = null;
        this._nameIndex = null;
    }

    private void refreshVariables() {
        VariablesIterator iterator = VariablesController.getInstance().iterator(this.getDocument().getFile(), this.isWorkingCopy());
        this._variables = iterator.getVariables();
        this._nameIndex = iterator.getNameIndex();
    }

    @Override
    public void setOffset(int offset) {
        this.reset();
        this.internalSetOffset(offset);
    }
}

