/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.variables;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.JavaModelException;

public class AnnotationInfo {
    private String _name;
    private List<MemberValuePair> _pairs;

    public AnnotationInfo(IAnnotation anno) {
        this._name = anno.getElementName();
        this._pairs = new ArrayList<MemberValuePair>();
        try {
            int i = 0;
            while (i < anno.getMemberValuePairs().length) {
                this._pairs.add(new MemberValuePair(anno.getMemberValuePairs()[i]));
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    public String getName() {
        return this._name;
    }

    public List<MemberValuePair> getMemberPairs() {
        return this._pairs;
    }

    public class MemberValuePair
    implements IMemberValuePair {
        private int _kind;
        private String _memberName;
        private Object _value;
        private List<AnnotationInfo> _annos;

        public MemberValuePair(IMemberValuePair pair) {
            this._memberName = pair.getMemberName();
            this._value = pair.getValue();
            this._kind = pair.getValueKind();
            this.init(pair);
        }

        private void init(IMemberValuePair pair) {
            if (pair.getValueKind() == 10 && pair.getValue() instanceof Object[]) {
                this._annos = new ArrayList<AnnotationInfo>();
                Object[] annos = (Object[])pair.getValue();
                int i = 0;
                while (i < annos.length) {
                    this._annos.add(new AnnotationInfo((IAnnotation)annos[i]));
                    ++i;
                }
            }
        }

        public int getValueKind() {
            return this._kind;
        }

        public String getMemberName() {
            return this._memberName;
        }

        public Object getValue() {
            return this._value;
        }

        public List<AnnotationInfo> getAnnotationInfo() {
            return this._annos;
        }
    }
}

