/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.util;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import oracle.eclipse.tools.application.common.services.Activator;
import oracle.eclipse.tools.application.common.services.util.FileUtil;
import oracle.eclipse.tools.application.common.services.util.LogMgr;
import oracle.eclipse.tools.common.services.util.ObjectUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolverPlugin;
import org.eclipse.wst.sse.core.utils.StringUtils;

public class UrlUtil {
    private static final String REGULAR_SPACE = " ";
    private static final String URI_ENCODED_SPACE = "%20";
    public static final String FILE_PROTOCOL = "file";
    public static final String HTTP_PROTOCOL = "http";
    public static final String HTTPS_PROTOCOL = "https";
    public static final String JAR_PROTOCOL = "jar";

    public static IPath resolveUri(IResource referencingResource, String uriStr) {
        if (referencingResource == null || uriStr == null) {
            return null;
        }
        String modifiedUriStr = StringUtils.strip((String)uriStr);
        modifiedUriStr = modifiedUriStr.trim();
        modifiedUriStr = modifiedUriStr.replace('|', ':');
        URI uri = UrlUtil.getURI(modifiedUriStr = modifiedUriStr.replace(REGULAR_SPACE, URI_ENCODED_SPACE));
        if (uri == null || uri.isAbsolute()) {
            return null;
        }
        String path = uri.getPath();
        String query = uri.getQuery();
        String fragment = uri.getFragment();
        IPath resolved = null;
        if (!(path != null && path.length() != 0 || query == null && fragment == null)) {
            resolved = referencingResource.getFullPath();
        } else if (path != null && path.length() > 0) {
            Path location;
            modifiedUriStr = URIResolverPlugin.createResolver().resolve(referencingResource.getLocation().toString(), null, path);
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IFile res = root.getFileForLocation((IPath)(location = new Path(modifiedUriStr)));
            if (res == null) {
                res = root.getContainerForLocation((IPath)location);
            }
            if (res != null) {
                resolved = res.getFullPath();
            }
        }
        return resolved;
    }

    public static String makeRelative(URL parentUrl, URL childUrl) {
        if (childUrl == null) {
            return null;
        }
        String childFile = childUrl.getFile();
        String parentFile = parentUrl.getFile();
        return UrlUtil.getRelativePath(parentFile, childFile);
    }

    public static boolean isParentUrl(URL parentUrl, URL childUrl) {
        try {
            String tmp = parentUrl.toString().replace(REGULAR_SPACE, URI_ENCODED_SPACE);
            URI parentUri = new URI(tmp);
            tmp = childUrl.toString().replace(REGULAR_SPACE, URI_ENCODED_SPACE);
            URI childUri = new URI(tmp);
            URI relative = parentUri.relativize(childUri);
            if (relative.isAbsolute()) {
                return ObjectUtil.equalObjects((Object)parentUrl.getProtocol(), (Object)childUrl.getProtocol()) && ObjectUtil.equalObjects((Object)parentUrl.getHost(), (Object)childUrl.getHost()) && ObjectUtil.equalObjects((Object)parentUrl.getPath(), (Object)childUrl.getPath());
            }
            return true;
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
    }

    public static String getUrlFileName(URL url) {
        int slashIndex;
        if (url == null) {
            return null;
        }
        String path = url.getPath();
        if (path.length() == 0) {
            return null;
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ((slashIndex = path.lastIndexOf(47)) < 0) {
            return path;
        }
        return path.substring(slashIndex + 1);
    }

    public static boolean isFileUrl(URL url) {
        return url != null && FILE_PROTOCOL.equals(url.getProtocol());
    }

    public static boolean isJarUrl(URL url) {
        return url != null && JAR_PROTOCOL.equals(url.getProtocol());
    }

    public static boolean isHttpUrl(URL url) {
        if (url != null) {
            String protocol = url.getProtocol();
            return HTTP_PROTOCOL.equals(protocol) || HTTPS_PROTOCOL.equals(protocol);
        }
        return false;
    }

    public static File getUrlFile(URL url) {
        File file;
        if (!UrlUtil.isFileUrl(url)) {
            return null;
        }
        try {
            file = new File(url.getPath());
            if (file.exists()) {
                return file;
            }
        }
        catch (Exception exception) {}
        try {
            file = new File(url.toURI());
            if (file.exists()) {
                return file;
            }
        }
        catch (Exception exception) {}
        try {
            return new File(URLDecoder.decode(url.getFile(), "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static URL getJarFileUrl(URL url) {
        if (!UrlUtil.isJarUrl(url)) {
            return null;
        }
        String file = url.getFile();
        int index = file.indexOf(33);
        if (index < 0) {
            return null;
        }
        String jarFileUrlStr = file.substring(0, index);
        try {
            return new URL(jarFileUrlStr);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static String getJarEntryFromJarUrl(URL url) {
        if (!UrlUtil.isJarUrl(url)) {
            return null;
        }
        String file = url.getFile();
        int index = file.indexOf(33);
        if (index < 0) {
            return null;
        }
        String s = file.substring(index + 1);
        if (s.startsWith("/")) {
            s = s.substring(1);
        }
        return s;
    }

    public static URL getJarEntryUrl(JarFile jarFile, JarEntry jarEntry) {
        try {
            String entryName = jarEntry.getName();
            if (entryName.startsWith("/")) {
                entryName = entryName.substring(1);
            }
            String urlstr = "jar:" + FileUtil.getFileUrl(new File(jarFile.getName())) + "!/" + entryName;
            return new URL(urlstr);
        }
        catch (MalformedURLException e) {
            LogMgr.getUnhandledExceptionLogger().error("getJarEntryUrl", e);
            return null;
        }
    }

    public static String removeTrailingSlash(String path) {
        if (path == null || path.length() == 0) {
            return path;
        }
        int index = path.length() - 1;
        if (path.charAt(index) == '/') {
            return path.substring(0, index);
        }
        return path;
    }

    public static String getRelativePath(String parentFile, String childFile) {
        String fixedChildFile = childFile;
        String fixedParentFile = parentFile;
        fixedChildFile = fixedChildFile.replace(File.separatorChar, '/');
        fixedParentFile = fixedParentFile.replace(File.separatorChar, '/');
        if ((fixedChildFile = UrlUtil.removeTrailingSlash(fixedChildFile)).equals(fixedParentFile = UrlUtil.removeTrailingSlash(fixedParentFile))) {
            return "./";
        }
        String commonSpec = fixedChildFile;
        int index = fixedChildFile.length();
        while (commonSpec.length() > 0) {
            index = commonSpec.lastIndexOf(47);
            if (index < 0) break;
            commonSpec = fixedChildFile.substring(0, index);
            if (!fixedParentFile.startsWith(commonSpec)) continue;
            fixedParentFile = fixedParentFile.substring(commonSpec.length());
            fixedChildFile = fixedChildFile.substring(commonSpec.length());
            break;
        }
        StringBuffer buffer = new StringBuffer(fixedChildFile);
        String separator = "..";
        while (fixedParentFile.length() > 0) {
            buffer.insert(0, separator);
            index = fixedParentFile.lastIndexOf(47);
            if (index < 0) break;
            fixedParentFile = fixedParentFile.substring(0, index);
            separator = "../";
        }
        String result = buffer.toString();
        if (result.length() > 0 && result.charAt(0) == '/') {
            return result.substring(1);
        }
        return result;
    }

    public static boolean looksLikeWebUri(String uri) {
        if (uri == null) {
            return false;
        }
        int indexofSlash = uri.indexOf(47);
        String fixedUri = uri;
        if (indexofSlash > 0) {
            fixedUri = fixedUri.substring(0, indexofSlash);
        }
        return fixedUri.startsWith("javascript:") || fixedUri.startsWith("news:") || fixedUri.startsWith("www.") || fixedUri.startsWith("ftp.") || fixedUri.endsWith(".org") || fixedUri.endsWith(".com");
    }

    public static URL getURL(URI uri) {
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)e);
            return null;
        }
    }

    public static URI getURI(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }
}

