/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.util;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import oracle.eclipse.tools.common.util.PluginUtil;

public class ResourceUtil {
    private static ResourceUtil instance = null;

    public static synchronized ResourceUtil getInstance() {
        if (instance == null) {
            instance = new ResourceUtil();
        }
        return instance;
    }

    public String getMessage(String baseName, String key, ClassLoader loader) {
        ResourceBundle rb = null;
        try {
            rb = ResourceBundle.getBundle(baseName, Locale.getDefault(), loader);
        }
        catch (MissingResourceException missingResourceException) {
            ClassLoader pluginLoader = PluginUtil.loadClass((String)"com.m7.nitrox", (String)"com.m7.wide.eclipse.jstudio.Plugin").getClassLoader();
            rb = ResourceBundle.getBundle(baseName, Locale.getDefault(), pluginLoader);
        }
        return rb.getString(key);
    }

    public String getMessage(String baseName, String key) {
        return this.getMessage(baseName, key, this.getClass().getClassLoader());
    }

    public String getMessage(String baseName, String key, String param) {
        String result = this.getMessage(baseName, key);
        MessageFormat f = new MessageFormat(result);
        Object[] args = new Object[]{param};
        return f.format(args);
    }

    public String getMessage(String baseName, String key, String param1, String param2) {
        String result = this.getMessage(baseName, key);
        MessageFormat f = new MessageFormat(result);
        Object[] args = new Object[]{param1, param2};
        return f.format(args);
    }

    public String getMessage(String baseName, String key, String param1, String param2, String param3) {
        String result = this.getMessage(baseName, key);
        MessageFormat f = new MessageFormat(result);
        Object[] args = new Object[]{param1, param2, param3};
        return f.format(args);
    }

    public String getMessage(String baseName, String key, Object[] params) {
        String result = this.getMessage(baseName, key);
        MessageFormat f = new MessageFormat(result);
        return f.format(params);
    }
}

