/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.util;

import java.util.Collections;
import java.util.Locale;
import oracle.eclipse.tools.application.common.services.appservices.IBundleResource;
import oracle.eclipse.tools.application.common.services.appservices.IDesignTimeLocaleService;
import oracle.eclipse.tools.application.common.services.documentservices.IDocumentLocalizationContext;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.common.services.document.IFilePositionContext;

public final class LocalizeUtil {
    public static final LocalizeUtil INSTANCE = new LocalizeUtil();

    public IBundleResource getBundleResource(IFilePositionContext fileContext, String basename) {
        IDocument document = (IDocument)fileContext.getFile().getAdapter(IDocument.class);
        if (document == null) {
            return null;
        }
        return this.getBundleResource(fileContext.getOffset(), basename, document);
    }

    public IBundleResource getBundleResource(int offset, String basename, IDocument document) {
        IDesignTimeLocaleService localeSvc = (IDesignTimeLocaleService)document.getProject().getAppService(IDesignTimeLocaleService.class);
        if (localeSvc != null) {
            IDocumentLocalizationContext context;
            Locale preferredLocale = localeSvc.getCurrentLocale();
            if (preferredLocale == null) {
                preferredLocale = Locale.getDefault();
            }
            if ((context = (IDocumentLocalizationContext)document.getAdapter(IDocumentLocalizationContext.class)) != null) {
                Locale locales = context.resolveLocale(offset, Collections.singletonList(preferredLocale));
                IBundleResource bundleResource = context.resolveBundle(offset, basename.trim(), locales);
                return bundleResource;
            }
        }
        return null;
    }
}

