/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.resource;

import java.util.Collection;
import java.util.List;
import oracle.eclipse.tools.application.common.services.resource.IResourceBundleExt;
import oracle.eclipse.tools.application.common.services.resource.ResourceBundleUtil;
import oracle.eclipse.tools.application.common.services.variables.DocumentVariableQuery;
import oracle.eclipse.tools.application.common.services.variables.ELExpression;
import oracle.eclipse.tools.application.common.services.variables.JavaResourceBundleDataType;
import oracle.eclipse.tools.application.common.services.variables.ResolutionTime;
import oracle.eclipse.tools.application.common.services.variables.ValueReferenceELParser;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.application.common.services.variables.VariableQuery;
import oracle.eclipse.tools.common.services.document.IDocument;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class BindUtil {
    public static final BindUtil INSTANCE = new BindUtil();

    private BindUtil() {
    }

    public BindDialogTab getTabsToShow(EObject eObject, EStructuralFeature eFeature, Collection<ResolutionTime> expectedResTime) {
        IResourceBundleExt bundleExt;
        if (this.requiresImplicitBundle(eObject) && (bundleExt = ResourceBundleUtil.INSTANCE.getBundleExtFromLocalizationContext(eObject, eFeature)) == null) {
            return BindDialogTab.VARIABLES;
        }
        Variable[] vars = ResourceBundleUtil.INSTANCE.getExternalVariableBundles(eObject, eFeature, expectedResTime);
        if (vars.length == 0) {
            return BindDialogTab.VARIABLES;
        }
        return BindDialogTab.ALL;
    }

    public BindDialogTab getDefaultTab(EObject eObject, EStructuralFeature eFeature) {
        NameMatcherForVar matcher;
        Object value = eObject.eGet(eFeature);
        if (!(value instanceof String)) {
            return BindDialogTab.VARIABLES;
        }
        ValueReferenceELParser parser = new ValueReferenceELParser();
        String stringValue = ((String)value).trim();
        ELExpression expr = parser.getELExpression(stringValue);
        if (expr == null) {
            return BindDialogTab.VARIABLES;
        }
        List<ValueReferenceELParser.ValueReferenceELExpr> exprs = parser.getExpressions(expr.getElText());
        if (exprs.size() == 0) {
            return BindDialogTab.VARIABLES;
        }
        String varName = exprs.get(0).getModelObjectName();
        IFile iFile = ResourceBundleUtil.INSTANCE.getBaseFile(eObject);
        if (iFile == null) {
            return BindDialogTab.VARIABLES;
        }
        IDocument iDoc = ResourceBundleUtil.INSTANCE.getDocument(iFile);
        DocumentVariableQuery bundleVarQuery = new DocumentVariableQuery(iDoc, (int)ResourceBundleUtil.INSTANCE.getOffset(eObject, eFeature));
        List<Variable> variables = ((VariableQuery)bundleVarQuery).findVariable(matcher = new NameMatcherForVar(varName, expr));
        if (variables == null || variables.size() == 0) {
            return BindDialogTab.VARIABLES;
        }
        Variable var = variables.get(0);
        if (var.getType() instanceof JavaResourceBundleDataType) {
            return BindDialogTab.RESOURCES;
        }
        return BindDialogTab.VARIABLES;
    }

    private boolean requiresImplicitBundle(EObject eObject) {
        return false;
    }

    public static enum BindDialogTab {
        VARIABLES,
        RESOURCES,
        ALL;

    }

    private static final class NameMatcherForVar
    extends VariableQuery.NameMatcher {
        private final boolean _isRuntimeExpr;

        public NameMatcherForVar(String varName, ELExpression expr) {
            super(varName);
            this._isRuntimeExpr = expr.getEscapeType() == ELExpression.EscapeType.HASH_SIGN;
        }

        @Override
        public boolean matches(Variable variable) {
            if (super.matches(variable)) {
                if (this._isRuntimeExpr && variable.getResolutionType().isRuntimeVisible()) {
                    return true;
                }
                if (!this._isRuntimeExpr && variable.getResolutionType().isCompileTimeVisible()) {
                    return true;
                }
            }
            return false;
        }
    }
}

