/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.metadata.query.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import oracle.eclipse.tools.application.common.services.metadata.IVariant;
import oracle.eclipse.tools.application.common.services.metadata.IVersion;
import oracle.eclipse.tools.application.common.services.metadata.Trait2;
import oracle.eclipse.tools.application.common.services.metadata.query.internal.SearchControl;
import oracle.eclipse.tools.application.common.services.metadata.query.internal.SimpleResultSet;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.query.AbstractTraitQueryVisitor;
import org.eclipse.jst.jsf.common.metadata.query.IResultSet;
import org.eclipse.jst.jsf.common.metadata.query.ITraitVisitor;
import org.eclipse.jst.jsf.common.metadata.query.internal.IPredicateMatcher;

public class TraitQueryVisitorInexactMatchImpl
extends AbstractTraitQueryVisitor {
    private String _traitQuery;
    private SearchControl _control;
    private boolean _stop;
    private List<MatchedTrait> _traitResults;
    private IVersion _versionContext;
    private IVariant _variantContext;

    public TraitQueryVisitorInexactMatchImpl() {
        this(new SearchControl());
    }

    public TraitQueryVisitorInexactMatchImpl(SearchControl control) {
        this._control = control;
    }

    public void setVersionContext(IVersion version) {
        this._versionContext = version;
    }

    public void setVariantContext(IVariant variant) {
        this._variantContext = variant;
    }

    public IResultSet<Trait> findTraits(Entity entity, String traitQuery) {
        this.resetQuery();
        if (entity != null) {
            this._traitQuery = traitQuery;
            for (Trait t : entity.getTraits()) {
                t.accept((ITraitVisitor)this);
                if (this.stopVisiting()) break;
            }
        }
        return new SimpleResultSet<Trait>(this.getSortedTraitResults());
    }

    private List<Trait> getSortedTraitResults() {
        Collections.sort(this.getInternalTraitResults());
        ArrayList<Trait2> results = new ArrayList<Trait2>(this.getInternalTraitResults().size());
        Iterator<MatchedTrait> it = this.getInternalTraitResults().iterator();
        while (it.hasNext()) {
            results.add(it.next().getTrait());
        }
        return Collections.unmodifiableList(results);
    }

    public void visit(Trait trait) {
        MatchedTrait matchedTrait;
        if (!(trait instanceof Trait2)) {
            System.out.println("Stop");
        }
        if ((matchedTrait = new MatchedTrait((Trait2)trait)).isMatched()) {
            this.getInternalTraitResults().add(matchedTrait);
        }
        this.checkShouldStopVisitingTraits();
    }

    private void resetQuery() {
        this._stop = false;
        this._traitResults = null;
    }

    private List<MatchedTrait> getInternalTraitResults() {
        if (this._traitResults == null) {
            this._traitResults = new ArrayList<MatchedTrait>();
        }
        return this._traitResults;
    }

    public boolean stopVisiting() {
        return this._stop;
    }

    private void checkShouldStopVisitingTraits() {
        if (this._control.getCountLimit() == this.getInternalTraitResults().size() && this._control.getCountLimit() != -1) {
            this._stop = true;
        }
    }

    private class MatchedTrait
    implements Comparable<MatchedTrait> {
        private IPredicateMatcher.MATCH idMatch = IPredicateMatcher.MATCH.NOT;
        private IPredicateMatcher.MATCH versionMatch = IPredicateMatcher.MATCH.NOT;
        private IPredicateMatcher.MATCH variantMatch = IPredicateMatcher.MATCH.FULLY;
        private Trait2 trait;

        public MatchedTrait(Trait2 trait) {
            this.trait = trait;
            this.init();
        }

        public boolean isMatched() {
            return this.idMatch == IPredicateMatcher.MATCH.FULLY && this.versionMatch != IPredicateMatcher.MATCH.NOT && this.variantMatch != IPredicateMatcher.MATCH.NOT;
        }

        private void init() {
            if (this.trait.getId().equals(TraitQueryVisitorInexactMatchImpl.this._traitQuery)) {
                IVersion v;
                int compare;
                this.idMatch = IPredicateMatcher.MATCH.FULLY;
                this.versionMatch = TraitQueryVisitorInexactMatchImpl.this._versionContext == null ? IPredicateMatcher.MATCH.PARTIALLY : ((compare = (v = this.trait.getVersion()).compareTo(TraitQueryVisitorInexactMatchImpl.this._versionContext)) == 0 ? IPredicateMatcher.MATCH.FULLY : (compare < 0 ? IPredicateMatcher.MATCH.PARTIALLY : IPredicateMatcher.MATCH.NOT));
                if (this.versionMatch != IPredicateMatcher.MATCH.NOT) {
                    IVariant variant = this.trait.getVariant();
                    compare = variant.compareTo(TraitQueryVisitorInexactMatchImpl.this._variantContext);
                    this.variantMatch = compare == 0 ? IPredicateMatcher.MATCH.FULLY : (compare > 0 ? IPredicateMatcher.MATCH.PARTIALLY : IPredicateMatcher.MATCH.NOT);
                }
            }
        }

        public Trait2 getTrait() {
            return this.trait;
        }

        @Override
        public int compareTo(MatchedTrait o2) {
            int versionCompare = o2.getTrait().getVersion().compareTo(this.getTrait().getVersion());
            if (versionCompare == 0 && o2.getTrait().getVariant().compareTo(this.getTrait().getVariant()) != 0) {
                if (this.variantMatch == IPredicateMatcher.MATCH.FULLY) {
                    return -1;
                }
                return 1;
            }
            return versionCompare;
        }
    }
}

