/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.metadata.query.internal;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.application.common.services.metadata.IVariant;
import oracle.eclipse.tools.application.common.services.metadata.IVersion;
import oracle.eclipse.tools.application.common.services.metadata.Trait2;
import oracle.eclipse.tools.application.common.services.metadata.query.internal.SearchControl;
import oracle.eclipse.tools.application.common.services.metadata.query.internal.SimpleResultSet;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.query.AbstractTraitQueryVisitor;
import org.eclipse.jst.jsf.common.metadata.query.IResultSet;
import org.eclipse.jst.jsf.common.metadata.query.ITraitVisitor;

public class TraitQueryVisitorExactMatchImpl
extends AbstractTraitQueryVisitor {
    private String _traitQuery;
    private SearchControl _control;
    private boolean _stop;
    private List<Trait> _traitResults;
    private IVersion _versionContext;
    private IVariant _variantContext = IVariant.ANY;

    public TraitQueryVisitorExactMatchImpl() {
        this(new SearchControl());
    }

    public TraitQueryVisitorExactMatchImpl(SearchControl control) {
        this._control = control;
    }

    public void setVersionContext(IVersion version) {
        this._versionContext = version;
    }

    public void setVariantContext(IVariant variant) {
        this._variantContext = variant;
    }

    public IResultSet<Trait> findTraits(Entity entity, String traitQuery) {
        this.resetQuery();
        if (entity != null) {
            this._traitQuery = traitQuery;
            for (Trait t : entity.getTraits()) {
                t.accept((ITraitVisitor)this);
                if (this.stopVisiting()) break;
            }
        }
        return new SimpleResultSet<Trait>(this.getInternalTraitResults());
    }

    public void visit(Trait trait) {
        if (trait.getId().equals(this._traitQuery)) {
            Trait2 t2 = (Trait2)trait;
            if ((this._versionContext == null || t2.getVersion().equals(this._versionContext)) && (this._variantContext == null || t2.getVariant().equals(this._variantContext))) {
                this.getInternalTraitResults().add(trait);
            }
        }
        this.checkShouldStopVisitingTraits();
    }

    private void resetQuery() {
        this._stop = false;
        this._traitResults = null;
    }

    private List<Trait> getInternalTraitResults() {
        if (this._traitResults == null) {
            this._traitResults = new ArrayList<Trait>();
        }
        return this._traitResults;
    }

    public boolean stopVisiting() {
        return this._stop;
    }

    private void checkShouldStopVisitingTraits() {
        if (this._control.getCountLimit() == this.getInternalTraitResults().size() && this._control.getCountLimit() != -1) {
            this._stop = true;
        }
    }
}

