/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.metadata.query.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.eclipse.tools.application.common.services.metadata.query.internal.SearchControl;
import oracle.eclipse.tools.application.common.services.metadata.query.internal.SimpleResultSet;
import oracle.eclipse.tools.application.common.services.metadata.query.internal.TraitSearchPolicyControl;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.query.AbstractTraitQueryVisitor;
import org.eclipse.jst.jsf.common.metadata.query.IResultSet;
import org.eclipse.jst.jsf.common.metadata.query.ITraitVisitor;
import org.eclipse.jst.jsf.common.metadata.query.MetaDataException;
import org.eclipse.jst.jsf.common.metadata.query.internal.IPredicateMatcher;

public class TraitQuerySpecVisitor
extends AbstractTraitQueryVisitor {
    private List<Trait> _traitResults;
    private Collection<Entity> _entities;
    private IPredicateMatcher<Trait> _matcher;
    private SearchControl _control;
    private boolean _stop;
    private boolean _exactMatchFound;

    public TraitQuerySpecVisitor(Collection<Entity> entities, IPredicateMatcher<Trait> traitMatcher) {
        this(entities, traitMatcher, new TraitSearchPolicyControl(false));
    }

    public TraitQuerySpecVisitor(Collection<Entity> entities, IPredicateMatcher<Trait> traitMatcher, SearchControl control) {
        this._entities = entities;
        this._matcher = traitMatcher;
        this._traitResults = new ArrayList<Trait>();
        this._control = control;
    }

    public IResultSet<Trait> findTraits() throws MetaDataException {
        this._matcher.reset();
        if (this._entities != null && this._entities.size() > 0) {
            block0: for (Entity entity : this._entities) {
                for (Trait trait : entity.getTraits()) {
                    trait.accept((ITraitVisitor)this);
                    this.checkShouldStopVisiting();
                    if (this.stopVisiting()) break block0;
                }
            }
        }
        return new SimpleResultSet<Trait>(this._traitResults);
    }

    public boolean stopVisiting() {
        return this._stop;
    }

    private void checkShouldStopVisiting() {
        if (!this._stop) {
            if (this._control instanceof TraitSearchPolicyControl) {
                TraitSearchPolicyControl c = (TraitSearchPolicyControl)this._control;
                if (this._exactMatchFound && c.shouldStopOnFirstExactMatch()) {
                    this._stop = true;
                }
            }
            if (this._control.getCountLimit() == this._traitResults.size() && this._control.getCountLimit() != -1) {
                this._stop = true;
            }
        }
    }

    public void visit(Trait trait) {
        IPredicateMatcher.MATCH match = this._matcher.matches((Object)trait);
        if (match == IPredicateMatcher.MATCH.FULLY) {
            this._traitResults.add(0, trait);
            this._exactMatchFound = true;
        } else if (match == IPredicateMatcher.MATCH.PARTIALLY) {
            this._traitResults.add(trait);
        }
    }
}

