/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.metadata.query.internal;

import oracle.eclipse.tools.application.common.services.Activator;
import oracle.eclipse.tools.application.common.services.metadata.IVariant;
import oracle.eclipse.tools.application.common.services.metadata.IVersion;
import oracle.eclipse.tools.application.common.services.metadata.query.internal.HierarchicalSearchControl;
import oracle.eclipse.tools.application.common.services.metadata.query.internal.MetaDataModelContext;
import oracle.eclipse.tools.application.common.services.metadata.query.internal.MetadataModelContextAdapterFactory;
import oracle.eclipse.tools.application.common.services.metadata.query.internal.SimpleEntityQueryVisitorImpl;
import oracle.eclipse.tools.application.common.services.metadata.query.internal.TraitQueryVisitorInexactMatchImpl;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.Model;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataDomainContext;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataModelContext;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataModelManager;
import org.eclipse.jst.jsf.common.metadata.query.IEntityQueryVisitor;
import org.eclipse.jst.jsf.common.metadata.query.IResultSet;
import org.eclipse.jst.jsf.common.metadata.query.ITraitQueryVisitor;
import org.eclipse.jst.jsf.common.metadata.query.MetaDataException;
import org.eclipse.jst.jsf.common.metadata.query.internal.IMetaDataQueryHelper;

public class MetaDataQueryHelper
implements IMetaDataQueryHelper {
    private IMetaDataModelManager _manager;
    private IMetaDataDomainContext _metadataContext;
    private IVersion _versionContext;
    private IVariant _variantContext;
    private String _modelId;

    public MetaDataQueryHelper(IMetaDataModelManager manager, IMetaDataDomainContext managerContext) {
        this._manager = manager;
        this._metadataContext = managerContext;
    }

    public Model getModel(String modelId) {
        return this.getMDModel(modelId);
    }

    public Entity getEntity(String modelId, String entityKey) {
        SimpleEntityQueryVisitorImpl visitor = new SimpleEntityQueryVisitorImpl(new HierarchicalSearchControl(1, 2));
        IResultSet<Entity> rs = this.getEntities(modelId, entityKey, (IEntityQueryVisitor)visitor);
        return this.getFirstFromResultSet(rs);
    }

    public IResultSet<Entity> getEntities(String modelId, String entityKey, IEntityQueryVisitor visitor) {
        Model model = this.getModel(modelId);
        return this.getEntities((Entity)model, entityKey, visitor);
    }

    public Trait getTrait(Entity entity, String traitKey) {
        if (entity == null) {
            return null;
        }
        TraitQueryVisitorInexactMatchImpl visitor = new TraitQueryVisitorInexactMatchImpl();
        this.initializeContexts(visitor, entity);
        IResultSet<Trait> rs = this.getTraits(entity, traitKey, (ITraitQueryVisitor)visitor);
        return this.getFirstFromResultSet(rs);
    }

    private void initializeContexts(TraitQueryVisitorInexactMatchImpl visitor, Entity entity) {
        this.setModelId(entity.getModel().getId());
        visitor.setVersionContext(this.getVersionContext(entity));
        visitor.setVariantContext(this.getVariantContext(entity));
    }

    private void setModelId(String modelId) {
        if (modelId != this._modelId) {
            this._versionContext = null;
            this._modelId = modelId;
        }
        this._variantContext = null;
    }

    private IVersion getVersionContext(Entity entity) {
        if (this._versionContext == null) {
            org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataModelContext context = new org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataModelContext(this._modelId, this._metadataContext);
            this._versionContext = MetadataModelContextAdapterFactory.getInstance().getVersionContext((IMetaDataModelContext)context);
        }
        return this._versionContext;
    }

    private IVariant getVariantContext(Entity entity) {
        if (this._variantContext == null) {
            org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataModelContext context = new org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataModelContext(this._modelId, this._metadataContext);
            this._variantContext = MetadataModelContextAdapterFactory.getInstance().getVariantContext((IMetaDataModelContext)context);
            if (this._variantContext == null) {
                this._variantContext = IVariant.ANY;
            }
        }
        return this._variantContext;
    }

    public IResultSet<Trait> getTraits(Entity entity, String traitKey, ITraitQueryVisitor traitQueryVisitor) {
        IResultSet rs = traitQueryVisitor.findTraits(entity, traitKey);
        return rs;
    }

    public Entity getEntity(Entity initialEntityContext, String entityKey) {
        if (initialEntityContext == null) {
            return null;
        }
        SimpleEntityQueryVisitorImpl visitor = new SimpleEntityQueryVisitorImpl(new HierarchicalSearchControl(1, 2));
        IResultSet<Entity> rs = this.getEntities(initialEntityContext, entityKey, (IEntityQueryVisitor)visitor);
        return this.getFirstFromResultSet(rs);
    }

    public IResultSet<Entity> getEntities(Entity initialEntityContext, String entityQuery, IEntityQueryVisitor entityKeyQueryVisitor) {
        return entityKeyQueryVisitor.findEntities(initialEntityContext, entityQuery);
    }

    public Trait getTrait(String modelId, String entityKey, String traitKey) {
        Entity entity = this.getEntity(modelId, entityKey);
        Trait t = null;
        if (entity != null) {
            t = this.getTrait(entity, traitKey);
        }
        return t;
    }

    public <T> T getFirstFromResultSet(IResultSet<T> results) {
        T result = null;
        try {
            if (!results.getResults().isEmpty()) {
                result = (T)results.getResults().get(0);
            }
            results.close();
        }
        catch (MetaDataException ex) {
            Activator.log(4, "Error in getFirstFromResultSet()", ex);
        }
        return result;
    }

    private Model getMDModel(String modelId) {
        if (this._manager != null && modelId != null) {
            return this._manager.getModel(this.getModelContext(modelId));
        }
        return null;
    }

    protected IMetaDataModelContext getModelContext(String modelId) {
        return new MetaDataModelContext((IProject)this._metadataContext.getAdapter(IProject.class), this._metadataContext.getDomainId(), modelId);
    }
}

