/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.metadata.internal;

import oracle.eclipse.tools.application.common.services.metadata.IVersion;
import oracle.eclipse.tools.application.common.services.metadata.internal.IVersionRange;

public class VersionRange
implements IVersionRange {
    private IVersion _minVersion;
    private IVersion _maxVersion;
    private boolean _minVersionIncluded;
    private boolean _maxVersionIncluded;

    VersionRange(IVersion minVersion, boolean minInclusive, IVersion maxVersion, boolean maxInclusive) {
        this._minVersion = minVersion;
        this._minVersionIncluded = minInclusive;
        this._maxVersion = maxVersion;
        this._maxVersionIncluded = maxInclusive;
    }

    @Override
    public String getVersionRangeString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this._minVersionIncluded ? "[" : "(");
        buf.append(this._minVersion.getVersionString()).append(",").append(this._maxVersion.getVersionString());
        buf.append(this._maxVersionIncluded ? "]" : ")");
        return buf.toString();
    }

    @Override
    public boolean contains(IVersion version) {
        int minComp = this._minVersion.compareTo(version);
        int maxComp = this._maxVersion.compareTo(version);
        return (minComp == 0 && this._minVersionIncluded || minComp < 0) && (maxComp == 0 && this._maxVersionIncluded || maxComp > 0);
    }

    public String toString() {
        return "Version Range: " + this.getVersionRangeString();
    }

    @Override
    public IVersion getMinimumVersion() {
        return this._minVersion;
    }

    @Override
    public IVersion getMaximumVersion() {
        return this._maxVersion;
    }

    @Override
    public boolean isMinimumVersionInclusive() {
        return this._minVersionIncluded;
    }

    @Override
    public boolean isMaximumVersionInclusive() {
        return this._maxVersionIncluded;
    }
}

