/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.metadata.internal;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import oracle.eclipse.tools.application.common.services.Activator;
import oracle.eclipse.tools.application.common.services.metadata.internal.IMetaDataLocator2;
import oracle.eclipse.tools.application.common.services.metadata.internal.IMetaDataSourceModelProvider2;
import oracle.eclipse.tools.application.common.services.metadata.internal.IStandardMetaDataSourceInfo2;
import oracle.eclipse.tools.application.common.services.metadata.internal.PluginRelativeStandardMetaDataSourceFileLocator2;
import oracle.eclipse.tools.application.common.services.metadata.internal.StandardMetaDataSourceFileLocator2;
import oracle.eclipse.tools.application.common.services.metadata.internal.StandardModelFactory2;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.jsf.common.metadata.Model;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.IClassLoaderProvider;
import org.eclipse.jst.jsf.common.metadata.internal.IImageDescriptorProvider;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataLocator;
import org.eclipse.jst.jsf.common.metadata.internal.IResourceBundleProvider;
import org.eclipse.jst.jsf.common.metadata.internal.IResourceURLProvider;
import org.eclipse.jst.jsf.common.metadata.internal.TraitValueHelper;
import org.osgi.framework.Bundle;

public class StandardMetaDataFilesProvider2
implements IMetaDataSourceModelProvider2 {
    private IStandardMetaDataSourceInfo2 info;
    private Object model;
    private IMetaDataLocator2 locator;
    private StandardMetaDataSourceFileLocator2 fileLocator = null;
    private String uri;

    public String toString() {
        return this.info.toString();
    }

    public StandardMetaDataFilesProvider2(String uri, IStandardMetaDataSourceInfo2 info) {
        this.uri = uri;
        this.info = info;
    }

    private StandardMetaDataSourceFileLocator2 getFileLocator() {
        if (this.fileLocator == null) {
            if (this.info.getLocatorClassname() == null) {
                this.fileLocator = new PluginRelativeStandardMetaDataSourceFileLocator2();
            } else {
                Class<?> klass = Activator.loadClass(this.info.getLocatorClassname(), this.info.getBundleId());
                try {
                    this.fileLocator = (StandardMetaDataSourceFileLocator2)klass.newInstance();
                }
                catch (InstantiationException e) {
                    Activator.log("InstantiationException: StandardMetaDataFilesProvider.getFileLocator()", e);
                }
                catch (IllegalAccessException e) {
                    Activator.log("IllegalAccessException: StandardMetaDataFilesProvider.getFileLocator()", e);
                }
            }
            if (this.fileLocator != null) {
                this.fileLocator.setFileInfo(this.info);
            }
        }
        return this.fileLocator;
    }

    private InputStream getInputStream() throws IOException {
        if (this.getFileLocator() != null) {
            return this.getFileLocator().getInputStream();
        }
        return null;
    }

    public String getURI() {
        return String.valueOf(this.info.getBundleId()) + ":" + this.info.getLocation();
    }

    private URI getMDFileURI() {
        block3: {
            URL url;
            block4: {
                StandardMetaDataSourceFileLocator2 fileLocator2 = this.getFileLocator();
                if (fileLocator2 == null) break block3;
                url = fileLocator2.getURL();
                if (url != null) break block4;
                Activator.log("Couldn't locate meta-data file for " + fileLocator2.getFileInfo().getLocation(), new RuntimeException());
                return null;
            }
            try {
                java.net.URI uri = url.toURI();
                return URI.createURI((String)uri.toString());
            }
            catch (URISyntaxException e) {
                Activator.log("Metadata File Load Error: " + this.getFileLocator().getFileInfo().toString() + ": URISyntaxException: " + e.getMessage(), e);
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getSourceModel() {
        if (this.model != null) {
            return this.model;
        }
        InputStream inputStream = null;
        try {
            try {
                EList contents;
                URI uri = this.getMDFileURI();
                inputStream = this.getInputStream();
                if (inputStream == null || uri == null || (contents = StandardModelFactory2.getInstance().loadStandardFileResource(inputStream, this, uri)) == null || contents.isEmpty() || !(contents.get(0) instanceof Model)) return this.model;
                this.model = contents.get(0);
                return this.model;
            }
            catch (FileNotFoundException e) {
                Activator.log("FileNotFoundException", e);
                if (inputStream == null) return this.model;
                try {
                    inputStream.close();
                    return this.model;
                }
                catch (IOException e2) {
                    Activator.log("IOException (2): StandardMetaDataFilesProvider.getSourceModel():" + this.getModelName(), e2);
                }
                return this.model;
            }
            catch (IOException e) {
                Activator.log("IOException(1): StandardMetaDataFilesProvider.getSourceModel():" + this.getModelName(), e);
                if (inputStream == null) return this.model;
                try {
                    inputStream.close();
                    return this.model;
                }
                catch (IOException e3) {
                    Activator.log("IOException (2): StandardMetaDataFilesProvider.getSourceModel():" + this.getModelName(), e3);
                }
                return this.model;
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    Activator.log("IOException (2): StandardMetaDataFilesProvider.getSourceModel():" + this.getModelName(), e);
                }
            }
        }
    }

    private String getModelName() {
        return this.info.toString();
    }

    @Override
    public IMetaDataLocator2 getLocator2() {
        return this.locator;
    }

    @Override
    public void setLocator2(IMetaDataLocator2 locator) {
        this.locator = locator;
    }

    public IMetaDataLocator getLocator() {
        throw new UnsupportedOperationException("Cannot use IMetadataDataLocator.   Use IMetadataLocator2");
    }

    public void setLocator(IMetaDataLocator locator) {
        throw new UnsupportedOperationException("Cannot use IMetadataDataLocator.   Use IMetadataLocator2");
    }

    private ResourceBundle internalGetResourceBundle() {
        if (this.getFileLocator() != null) {
            try {
                return this.fileLocator.getResourceBundle();
            }
            catch (MissingResourceException e) {
                Activator.log("InternalGetResourceBundle1", e);
            }
            catch (IOException e) {
                Activator.log("InternalGetResourceBundle2", e);
            }
        }
        return null;
    }

    public Object getAdapter(Class klass) {
        final StandardMetaDataFilesProvider2 mdp = this;
        if (klass == IImageDescriptorProvider.class) {
            return new IImageDescriptorProvider(){
                String imageBase;

                public ImageDescriptor getImageDescriptor(String imagePath) {
                    String imagePath2 = imagePath;
                    imagePath2 = this.appendImageBase(imagePath2);
                    String bundleID = mdp.getFileLocator().getFileInfo().getBundleId();
                    URL url = FileLocator.find((Bundle)Platform.getBundle((String)bundleID), (IPath)new Path(imagePath2), null);
                    return ImageDescriptor.createFromURL((URL)url);
                }

                private String appendImageBase(String imagePath) {
                    return String.valueOf(this.getImageBase()) + imagePath;
                }

                private String getImageBase() {
                    if (this.imageBase == null) {
                        Model aModel = (Model)StandardMetaDataFilesProvider2.this.getSourceModel();
                        Trait t = this.getImageBasePath(aModel);
                        if (t == null) {
                            this.imageBase = "";
                        } else {
                            this.imageBase = TraitValueHelper.getValueAsString((Trait)t);
                            if (this.imageBase != null && this.imageBase.length() > 0) {
                                this.imageBase = String.valueOf(this.imageBase) + "/";
                            }
                        }
                    }
                    return this.imageBase;
                }

                private Trait getImageBasePath(Model aModel) {
                    for (Trait t : aModel.getTraits()) {
                        if (!t.getId().equals("images-base-path")) continue;
                        return t;
                    }
                    return null;
                }
            };
        }
        if (klass == IResourceBundleProvider.class) {
            return new IResourceBundleProvider(){

                public ResourceBundle getResourceBundle() {
                    return mdp.internalGetResourceBundle();
                }
            };
        }
        if (klass == IClassLoaderProvider.class) {
            return new IClassLoaderProvider(){

                public Class loadClass(String className) {
                    String bundleID = mdp.getFileLocator().getFileInfo().getBundleId();
                    try {
                        return Platform.getBundle((String)bundleID).loadClass(className);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        return null;
                    }
                }
            };
        }
        if (klass == IResourceURLProvider.class) {
            return new IResourceURLProvider(){

                public URL getResourceURL(String resourcePath) {
                    URL resourceURL = null;
                    String bundleID = mdp.getFileLocator().getFileInfo().getBundleId();
                    try {
                        resourceURL = FileLocator.resolve((URL)Platform.getBundle((String)bundleID).getResource(resourcePath));
                    }
                    catch (IOException iOException) {}
                    return resourceURL;
                }
            };
        }
        return null;
    }

    @Override
    public void release() {
        StandardModelFactory2.getInstance().removeResourceFromResourceSet(this.getMDFileURI());
        this.model = null;
    }

    @Override
    public String getModelIdentifier() {
        return this.uri;
    }
}

