/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.metadata.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.application.common.services.Activator;
import oracle.eclipse.tools.application.common.services.metadata.Trait2;
import oracle.eclipse.tools.application.common.services.metadata.internal.IMetaDataModelMergeAssistant2;
import oracle.eclipse.tools.application.common.services.metadata.internal.MetaDataModel2;
import oracle.eclipse.tools.application.common.services.metadata.internal.StandardModelFactory2;
import oracle.eclipse.tools.application.common.services.metadata.query.internal.HierarchicalSearchControl;
import oracle.eclipse.tools.application.common.services.metadata.query.internal.SearchControl;
import oracle.eclipse.tools.application.common.services.metadata.query.internal.SimpleEntityQueryVisitorImpl;
import oracle.eclipse.tools.application.common.services.metadata.query.internal.SimpleResultSet;
import oracle.eclipse.tools.application.common.services.metadata.query.internal.TraitQueryVisitorExactMatchImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jst.jsf.common.JSFCommonPlugin;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.EntityGroup;
import org.eclipse.jst.jsf.common.metadata.IncludeEntityGroup;
import org.eclipse.jst.jsf.common.metadata.Model;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataDomainContext;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataModelContext;
import org.eclipse.jst.jsf.common.metadata.query.MetaDataException;
import org.eclipse.jst.jsf.common.metadata.query.internal.IMetaDataQuery;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryFactory;

public class MetaDataModelMergeAssistantImpl2
implements IMetaDataModelMergeAssistant2 {
    private MetaDataModel2 mergedModel;
    private SimpleEntityQueryVisitorImpl _entityVisitor;
    private TraitQueryVisitorExactMatchImpl _traitVisitor;
    private Map<Entity, Set<Trait>> _traitMap;
    private Map<Entity, Set<Entity>> _entityMap;
    private Map<String, EntityGroup> _entityGroupMap;
    private boolean _includesMode;

    public MetaDataModelMergeAssistantImpl2(MetaDataModel2 model) {
        this.mergedModel = model;
        this._entityVisitor = new SimpleEntityQueryVisitorImpl(new HierarchicalSearchControl(1, 2));
        this._traitVisitor = new TraitQueryVisitorExactMatchImpl(new SearchControl(1));
        this._entityMap = new HashMap<Entity, Set<Entity>>();
        this._entityGroupMap = new HashMap<String, EntityGroup>();
        this._traitMap = new HashMap<Entity, Set<Trait>>();
    }

    @Override
    public MetaDataModel2 getMergedModel() {
        return this.mergedModel;
    }

    protected void addEntityGroup(EntityGroup entityGroup) {
        Model model = (Model)this.getMergedModel().getRoot();
        if (!this.isExistingEntityGroup(model, entityGroup)) {
            this.getEntityGroupReparentingMap().put(entityGroup.getId(), entityGroup);
        }
    }

    protected Entity addEntity(Entity entity) {
        Entity mmEntity = this.getMergedEntity(entity);
        if (mmEntity == null) {
            mmEntity = this.addEntityAsNecessary((Entity)entity.eContainer(), entity);
            return entity;
        }
        this.addIncludeGroupsAsNecessary(mmEntity, entity);
        return mmEntity;
    }

    protected Entity getMergedEntity(Entity queryRoot, String entityKey) {
        Entity ret = null;
        SimpleResultSet rs = (SimpleResultSet)this._entityVisitor.findEntities(queryRoot, entityKey);
        try {
            if (!rs.getResults().isEmpty()) {
                ret = (Entity)rs.getResults().get(0);
            }
            rs.close();
        }
        catch (MetaDataException e) {
            Activator.log(4, "Error in getMergedEntity()", e);
        }
        return ret;
    }

    private void addIncludeGroupsAsNecessary(Entity mmEntity, Entity entity) {
        for (IncludeEntityGroup grp : entity.getIncludeGroups()) {
            boolean found = false;
            for (IncludeEntityGroup grp2 : mmEntity.getIncludeGroups()) {
                if (!grp2.equals(grp)) continue;
                found = true;
                break;
            }
            if (found) continue;
            mmEntity.getIncludeGroups().add((Object)grp);
        }
    }

    private Entity addEntityAsNecessary(Entity parent, Entity entity) {
        if (this._includesMode) {
            Entity mmParent = null;
            Entity mmEntity = null;
            if (parent != null && (mmParent = this.getMergedEntity(parent)) == null) {
                mmParent = this.addEntityAsNecessary((Entity)entity.eContainer(), entity);
            }
            if (mmParent != null) {
                mmEntity = this.addEntityInternal(mmParent, entity);
                return mmEntity;
            }
            return mmEntity;
        }
        Entity parentMergedEntity = this.getMergedEntity((Entity)entity.eContainer());
        Set<Entity> entities = this.getEntityReparentingMap().get(parentMergedEntity);
        if (entities == null) {
            entities = new HashSet<Entity>();
            this.getEntityReparentingMap().put(parentMergedEntity, entities);
        }
        entities.add(entity);
        return entity;
    }

    private boolean isExistingEntityGroup(Model model, EntityGroup entityGroup) {
        Iterator it = model.getEntityGroups().iterator();
        while (it.hasNext()) {
            if (!entityGroup.getId().equals(((EntityGroup)it.next()).getId())) continue;
            return true;
        }
        return this.getEntityGroupReparentingMap().containsKey(entityGroup.getId());
    }

    private Entity getExistingChildEntity(Entity parent, Entity entity) {
        for (Entity foundEntity : parent.getChildEntities()) {
            if (!entity.getId().equals(foundEntity.getId())) continue;
            return foundEntity;
        }
        return null;
    }

    private Entity addEntityInternal(Entity parent, Entity entity) {
        EcoreUtil.Copier copier = new EcoreUtil.Copier();
        Entity mmEntity = (Entity)copier.copy((EObject)entity);
        copier.copyReferences();
        parent.getChildEntities().add((Object)mmEntity);
        return mmEntity;
    }

    private boolean addTrait(Entity entity, Trait2 trait) {
        return this.addTraitAsNecessary(entity, trait);
    }

    private boolean addTraitAsNecessary(Entity mergedEntity, Trait2 trait) {
        Trait mmTrait = this.getMergedTrait(mergedEntity, trait);
        if (mmTrait == null) {
            this.addTraitInternal(mergedEntity, trait);
            return true;
        }
        return false;
    }

    @Override
    public void setMergeComplete() {
        this._includesMode = true;
        Model model = (Model)this.getMergedModel().getRoot();
        if (model != null) {
            StandardModelFactory2.debug(">> Begin processIncludeGroups for: " + this.getMergedModel().getModelContext(), StandardModelFactory2.DEBUG_MD_LOAD);
            this.processIncludeGroups(model);
            StandardModelFactory2.debug(">> End processIncludeGroups for: " + this.getMergedModel().getModelContext(), StandardModelFactory2.DEBUG_MD_LOAD);
        }
    }

    private Trait addTraitInternal(Entity parent, Trait trait) {
        if (this._includesMode) {
            EcoreUtil.Copier copier = new EcoreUtil.Copier();
            Trait mmTrait = (Trait)copier.copy((EObject)trait);
            copier.copyReferences();
            parent.getTraits().add((Object)mmTrait);
            mmTrait.setSourceModelProvider(trait.getSourceModelProvider());
            return mmTrait;
        }
        Set<Trait> traits = this.getTraitReparentingMap().get(parent);
        if (traits == null) {
            traits = new HashSet<Trait>();
            this.getTraitReparentingMap().put(parent, traits);
        }
        traits.add(trait);
        return trait;
    }

    private Map<Entity, Set<Trait>> getTraitReparentingMap() {
        return this._traitMap;
    }

    private Map<Entity, Set<Entity>> getEntityReparentingMap() {
        return this._entityMap;
    }

    private Map<String, EntityGroup> getEntityGroupReparentingMap() {
        return this._entityGroupMap;
    }

    private Entity getMergedEntity(Entity entity) {
        if (entity instanceof Model) {
            return (Entity)this.mergedModel.getRoot();
        }
        Entity ret = null;
        String entityKey = this.getIdRelativeToRoot(entity);
        SimpleResultSet rs = (SimpleResultSet)this._entityVisitor.findEntities((Entity)this.mergedModel.getRoot(), entityKey);
        try {
            if (!rs.getResults().isEmpty()) {
                ret = (Entity)rs.getResults().get(0);
            }
            rs.close();
        }
        catch (MetaDataException e) {
            Activator.log(4, "Error in getMergedEntity()", e);
        }
        return ret;
    }

    private String getIdRelativeToRoot(Entity entity) {
        Entity e = entity;
        StringBuffer buf = new StringBuffer();
        while (e.eContainer() != null) {
            buf.insert(0, e.getId());
            if (e.eContainer() != null && e.eContainer().eContainer() != null) {
                buf.insert(0, "/");
            }
            e = (Entity)e.eContainer();
        }
        return buf.toString();
    }

    private Trait getMergedTrait(Entity entity, Trait2 trait) {
        this._traitVisitor.setVersionContext(trait.getVersion());
        this._traitVisitor.setVariantContext(trait.getVariant());
        SimpleResultSet rs = (SimpleResultSet)this._traitVisitor.findTraits(entity, trait.getId());
        Trait ret = null;
        try {
            if (!rs.getResults().isEmpty()) {
                ret = (Trait)rs.getResults().get(0);
            }
            rs.close();
        }
        catch (MetaDataException e) {
            Activator.log(4, "Error in getMergedTrait()", e);
        }
        return ret;
    }

    private void processIncludeGroups(Model root) {
        this.addEntityGroupReferencesRecursively((Entity)root);
    }

    private void addEntityGroupReferencesRecursively(Entity entity) {
        this.doIncludes(entity);
        int i = 0;
        int size = entity.getChildEntities().size();
        while (i < size) {
            this.addEntityGroupReferencesRecursively((Entity)entity.getChildEntities().get(i));
            ++i;
        }
    }

    private void doIncludes(Entity entity) {
        int j = 0;
        int groupsSize = entity.getIncludeGroups().size();
        while (j < groupsSize) {
            IncludeEntityGroup include = (IncludeEntityGroup)entity.getIncludeGroups().get(j);
            if (include.getId() != null) {
                if (include.getModelUri() == null || include.getModelUri().equals(this.getMergedModel().getModelContext().getModelIdentifier())) {
                    EntityGroup eg = ((Model)this.getMergedModel().getRoot()).findIncludeGroup(include.getId());
                    this.addIncludeRefs(entity, eg);
                } else {
                    this.addIncludeRefs(entity, include);
                }
            }
            ++j;
        }
    }

    private void addIncludeRefs(Entity entity, IncludeEntityGroup include) {
        IMetaDataModelContext modelContext = this.getMergedModel().getModelContext();
        IMetaDataQuery query = MetaDataQueryFactory.getInstance().createQuery((IMetaDataDomainContext)modelContext);
        Model externalModel = query.getQueryHelper().getModel(include.getModelUri());
        if (externalModel != null) {
            EntityGroup entityGroup = externalModel.findIncludeGroup(include.getId());
            this.addIncludeRefs(entity, entityGroup);
        } else {
            JSFCommonPlugin.log((int)4, (String)("Unable to load external metadata model refs for " + modelContext.getModelIdentifier() + " into " + include.getModelUri()));
        }
    }

    private void addIncludeRefs(Entity entity, EntityGroup entityGroup) {
        if (entityGroup == null) {
            return;
        }
        int i = 0;
        int size = entityGroup.getTraits().size();
        while (i < size) {
            this.addTrait(entity, (Trait2)entityGroup.getTraits().get(i));
            ++i;
        }
        i = 0;
        size = entityGroup.getChildEntities().size();
        while (i < size) {
            this.traverseAndAddIncludes(entity, (Entity)entityGroup.getChildEntities().get(i));
            ++i;
        }
    }

    private void traverseAndAddIncludes(Entity parent, Entity entity) {
        Entity mergedEntity = this.addIncludedEntityAsNecessary(parent, entity);
        for (Trait trait : entity.getTraits()) {
            this.addTraitAsNecessary(mergedEntity, (Trait2)trait);
        }
        for (Entity e : entity.getChildEntities()) {
            this.traverseAndAddIncludes(mergedEntity, e);
        }
    }

    private Entity addIncludedEntityAsNecessary(Entity parent, Entity entity) {
        Entity mergedEntity = this.getExistingChildEntity(parent, entity);
        if (mergedEntity == null) {
            mergedEntity = this.addEntityInternal(parent, entity);
        }
        return mergedEntity;
    }

    @Override
    public void mergeModel(Model model) {
        block1: {
            Model mk;
            block0: {
                this._includesMode = false;
                MetaDataModel2 mm = this.getMergedModel();
                mk = model;
                if (mm.getRoot() != null) break block0;
                mm.setRoot(mk);
                break block1;
            }
            if (mk == null) break block1;
            this.traverseAndAdd((Entity)mk);
        }
    }

    protected void traverseAndAdd(Entity entity) {
        Entity mmEntity = this.addEntity(entity);
        if (mmEntity != entity) {
            if (entity instanceof Model) {
                Model model = (Model)entity;
                Iterator it = model.getEntityGroups().iterator();
                while (it.hasNext()) {
                    this.addEntityGroup((EntityGroup)it.next());
                }
            }
            for (Trait trait : entity.getTraits()) {
                this.addTrait(mmEntity, (Trait2)trait);
            }
            for (Entity e : entity.getChildEntities()) {
                this.traverseAndAdd(e);
            }
        }
        if (entity instanceof Model) {
            this.reparent();
        }
    }

    private void reparent() {
        Iterator<Entity> it;
        for (Entity parent : this._entityMap.keySet()) {
            it = this._entityMap.get(parent).iterator();
            while (it.hasNext()) {
                parent.getChildEntities().add((Object)it.next());
            }
        }
        for (Entity parent : this._traitMap.keySet()) {
            it = this._traitMap.get(parent).iterator();
            while (it.hasNext()) {
                parent.getTraits().add((Object)((Trait)it.next()));
            }
        }
        for (EntityGroup eg : this._entityGroupMap.values()) {
            ((Model)this.getMergedModel().getRoot()).getEntityGroups().add((Object)eg);
        }
        this._entityMap.clear();
        this._entityGroupMap.clear();
        this._traitMap.clear();
    }
}

